/*
** $Source: C:/SRC/EXMBATCH/RCS/exmbatch.c $
** $Id: exmbatch.c 1.4 1998/10/15 03:15:14 rwhitby Exp $
**
** ExmBatch (System Manager compliant DOS commands)
** Copyright (c) 1997-1998  Rod Whitby <rwhitby@iname.com>
**
** exmbatch.c
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pal.h"        /* PAL library */
#include "palsc.h"      /* PAL SC support */
#include "palexm.h"     /* PAL SysMgr support */

void GetSelectedFile(char * buffer, char type);
void InsertFilename(char *Command);
void Exec(char *command);
void Exit(char *msg);

char *Title     = "  ExmBatch 1.5 (Oct 1998)  ";

char *WrkStr    = "99";
char *MemStr    = "111";
char *Command   = "echo ** Please configure exmbatch.exm **";
char *Copyright = "Copyright 1997 - 1998 "
                  "Rod Whitby <rwhitby@iname.com> "
                  "<http://rwhitby.home.ml.org/exmbatch.html>";

char  buffer[80];
EVENT app_event;
int   WorkSpace;
int   Memory;
int   Pause;
int   Lock;

void main(void)
{
  int  size;
  int  status;

  /* m_init_app(SYSTEM_MANAGER_VERSION); */
  m_init();

  PalInit(1);

  WorkSpace = atoi(WrkStr);
  Memory    = atoi(MemStr);
  Pause     = *(MemStr+1)-'0';
  Lock      = *(MemStr+2)-'0';

  /* If there is a '%' character in the command,
     then we may need to substitute the currently
     selected filename from the Filer application */
  if (strchr(Command, '%')) {
    InsertFilename(Command);
  }

#ifdef DEBUG
  MsgBox(Title,
         " | Command is: | %s |"
         " WorkSpace is: %d |"
         " Memory is: %d |"
         " Pause is: %d |"
         " Lock is: %d |",
         NULL, " OK ",
         Command, WorkSpace, Memory, Pause, Lock);
#endif

  /* Check for Software Carousel first */
  if (SCPresent() && (WorkSpace > 0) && (WorkSpace <= 12)) {

    /* Check the target workspace */
    SCSizeStatus(WorkSpace, &size, &status);

    /* Make sure that it is large enough */
    if (size < Memory) {
      if (!status && SCSetSize(WorkSpace, Memory)) {
        sprintf(buffer,
                "Cannot increase size of work area %d.",
                WorkSpace);
        Exit(buffer);
      }
    }

    /* If workspace is not active, then send a command */
    if (!status) {
      if (SCSendCommand(WorkSpace, Command)) {
        sprintf(buffer,
                "Cannot send command to work area %d.",
                WorkSpace);
        Exit(buffer);
      }
    }

    /* Switch to the target workspace */
    if (SCSwitch(WorkSpace)) {
      sprintf(buffer,
              "Cannot switch to work area %d.",
              WorkSpace);
      Exit(buffer);
    }
  }
  /* Just use normal DOS execution */
  else {
    Exec(Command);
  }

  /* Close down the EXM */

  PalDeInit(1);

  app_event.norm.do_event = DO_FINI;
  m_action(&app_event);

  return;
}

void GetSelectedFile(char * buffer, char type)
{
  int  i;

  BYTE far * dataseg;
  char far * fileptr;
  char drive;
  char size;

  struct task far *pTCB;
  WORD sTCB;

  /* Locate the Task Control Block */
  pTCB = m_get_TCB();
  sTCB = (WORD)m_get_TCB_size();

  /* Step through looking for the Filer */
  for (i = 0; i < sTCB; i++) {
    if ((pTCB[i].t_hotkey == FILER_KEY) &&
        IsAppActive(FILER_KEY)) {
      break;
    }
  }
  if (i == sTCB) {
    Exit("Filer must be active for filename substitution.");
  }

  /* Find the start of the FILER's data segment. */
  dataseg = (BYTE far *)((DWORD)pTCB[i].t_ds << 16);
  
  /* Work out with half of the filer is being used, and
     point to the directory & filename storage area. */
  if (*(dataseg + 0xcd94)) {
    fileptr = (char far *)(dataseg + 0xa3ce);
  }
  else {
    fileptr = (char far *)(dataseg + 0x7bea);
  }

  /* Copy the directory path into the buffer */
  m_getdrv(&drive);
  m_getdir(drive, buffer, &size);
  if (type == 'f') {
    buffer += size;
    /* Insert a trailing directory delimeter */
    if (size > 3) {
      *buffer++ = '\\';
    }
  }
  else if (type == 'd') {
    buffer += 2;
  }
  else if (type == 'p') {
    strncpy(buffer, buffer+2, size-2);
    buffer += (size-2);
  }
  else if (type == 't') {
    strncpy(buffer, buffer+2, size-2);
    buffer += (size-2);
    /* Insert a trailing directory delimeter */
    if (size > 3) {
      *buffer++ = '\\';
    }
  }

  /* Weed out filenames like '..' and 'C:'. */
  if ((*(fileptr) != '.') && (*(fileptr+1) != ':')) {
    if ((type == 'f') || (type == 'n') || (type == 'b')) {
      /* Copy the file basename into the buffer */
      for (i = 0; i < 8; i++) {
        if ((*(fileptr+i) <= ' ') || (*(fileptr+i) >= 0x7f) ||
            (*(fileptr+i) == '.')) {
          break;
        }
        *buffer++ = *(fileptr+i);
      }
    }
    fileptr += 8;
    if ((type == 'f') || (type == 'n') || (type == 'e')) {
      /* Copy the file extension into the buffer */
      if (*fileptr != ' ') {
        if ((type == 'f') || (type == 'n')) {
          *buffer++ = '.';
        }
        for (i = 0; i < 3; i++) {
          if ((*fileptr <= ' ') || (*fileptr >= 0x7f)) {
            break;
          }
          *buffer++ = *fileptr++;
        }
      }
    }
  }

  /* Terminate the string */
  *buffer = '\0';
  return;
}

void InsertFilename(char *Command)
{
  char *sp = Command;
  char *dp = buffer;
  char *p;

  /* Loop through looking for a '%' character */
  while ((p = strchr(sp, '%')) != NULL) {
    /* Copy everything before the '%' */
    strncpy(dp, sp, (p - sp));
    /* Point to where the '%' would go */
    dp = dp + (p - sp);

    /* '%' followed by a letter substitutes file information */
    if (*(p+1) != '%') {
      /* Insert the file name */
      GetSelectedFile(dp, *(p+1));
      /* Point to the terminator */
      dp = dp + strlen(dp);
      /* Move over the '%x' in the source string */
      sp = p + 2;
    }
    /* Double '%' means just insert a single '%' */
    else {
      /* Insert the single '%' */
      *dp++ = '%';
      /* Move over the '%%' in the source string */
      sp = p + 2;
    }
  }
  /* Copy everything after the last '%' sequence */
  strcpy(dp, sp);
  /* Put the substituted string back into Command */
  strcpy(Command, buffer);
}

void Exec(char *command)
{
  EXEC_STRUCT st_exec;

  strcpy(buffer, "/C ");
  strcat(buffer, command);
  st_exec.ex_file_spec = (char far *)"d:\\dos\\command.com";
  st_exec.ex_command_line = (char far *)buffer;
  if (Memory >= 100) {
    st_exec.ex_DOSsizek = 0xffff;
  }
  else {
    st_exec.ex_DOSsizek = 0;
  }
  st_exec.ex_pause = Pause;
  st_exec.ex_lock = Lock;
  app_event.execf.exec_struc_ptr = (void far *)&st_exec;
  app_event.norm.do_event = DO_EXEC_FULL;
  m_action(&app_event);
}

void Exit(char *msg)
{
  int  Done = FALSE;

/* The following command could be used here instead of all
   the event code, but it would be far less educational :-)
  MsgBox(Title, " | Error: %s | ", NULL, " OK ", msg);
*/

  MsgWin(Title, " | Error: %s | ", msg);

  while (!Done) {
    app_event.norm.do_event = DO_EVENT;
    m_action(&app_event);
    switch (app_event.norm.kind) {
      case E_DEACT:
        PalDeInit(1);
        break;
      case E_ACTIV:
        PalInit(1);
        MsgWin(Title, " | Error: %s | ", msg);
        break;
      case E_TERM:
      case E_BREAK:
      case E_KEY:
        Done = TRUE;
        break;
    }
  }

  PalDeInit(1);
  app_event.norm.do_event = DO_FINI;
  m_action(&app_event);
}

/* End of exmbatch.c */
