/* LOKI.H -- Loki Header File

	Written 1994 by Craig A. Finseth
	Copyright 1994 by Craig A. Finseth

*/

/* -------------------- We Begin -------------------- */

#include "lib.h"
#include "lores.h"

#if defined(MSDOS)
#if defined(MAIN)
#if !defined(SYSMGR)
#define STACKSIZE	((10 * 1024) / 16);
int _stklen = STACKSIZE;
#endif
#endif
#include <time.h>
time_t time();
struct tm *localtime();
#endif

/* -------------------- Constants -------------------- */

typedef	int KEYCODE;

	/* amount of time to delay for delayed echos -- this is a loop count*/
#if defined(MSDOS)
#define DELAYCOUNT	0
#else
#define DELAYCOUNT	1000
#endif

	/* size of the largest terminal to handle */
#if defined(MSDOS)
#define ROWMAX		43
#define COLMAX		80
#else
#define ROWMAX		132
#define COLMAX		240
#endif

	/* maximum limits */
#define MACROMAX	128		/* max size of a keyboard macro */
#define	STRMAX		60		/* size of a response */
#define LINEBUFFSIZE	255		/* size of an output line buffer */
#define SMALLBUFFSIZE	33

#define BIGBUFFSIZE	(FNAMEMAX)	/* largest of FNAMEMAX and previous
					buffer sizes */

	/* pseudo-key definitions */
#define KEYNONE		(-1)		/* no valid key */
#define KEYABORT	(-2)
#define KEYQUIT		(-3)
#define KEYREGEN	(-4)		/* regenerate display */
#define KEYHELP		(0x100 + 59)
#define KEYF1		(0x100 + 59)
#define KEYF2		(0x100 + 60)
#define KEYF3		(0x100 + 61)
#define KEYF4		(0x100 + 62)
#define KEYHOME		(0x100 + 71)
#define KEYUP		(0x100 + 72)
#define KEYPGUP		(0x100 + 73)
#define KEYLEFT		(0x100 + 75)
#define KEYRIGHT	(0x100 + 77)
#define KEYEND		(0x100 + 79)
#define KEYDOWN		(0x100 + 80)
#define KEYPGDN		(0x100 + 81)
#define KEYCEND		(0x100 + 117)
#define KEYCHOME	(0x100 + 119)

	/* character set masks from the resource file */
#define CSETMASK_LOW	1	/* lower case letter */
#define CSETMASK_UPP	2	/* upper case letter */
#define CSETMASK_SAME	4	/* same case letter (only one case available),
				also covers other characters included in
				tokens (e.g., _ if you like) */
#define CSETMASK_CNUM	8	/* calculator number */
#define CSETMASK_WHI	16	/* whitespace character (space, tab) */
#define CSETMASK_NL	32	/* newline character */
#define CSETMASK_SENT	64	/* sentence end character */
#define CSETMASK_CLOSE	128	/* closing punct. character */

#define CSETMASK_TOK	(CSETMASK_LOW | CSETMASK_UPP | CSETMASK_SAME)

/* -------------------- Configuration Settings -------------------- */

#define RES_FILENAME	"loki.ri"

#define UNIT_MAX	48	/* maximum number of units */
#define UNIT_SIZE	5	/* number of table entries per unit */
#define UNIT_WIDTH	64	/* maximum size of a formatted unit value */

#define NUM_FUNCS	10	/* number of function keys */
#define PANE_KEY_SIZE	2	/* number of function keys */
#define PANE_SIZE	(NUM_FUNCS * PANE_KEY_SIZE)
				/* number of table entries per pane */

#define BIN_SIZE	32	/* maximum binary word size */

#if defined(MAIN)
int key_method;
int screen_type;
#else
extern int key_method;
extern int screen_type;
#endif

/* -------------------- Display Uses -------------------- */

enum USES {		/* usage of each line */
	US_HEAD,	/* headers */
	US_TOPBAR,
	US_BLANK,
	US_M, 		/* memory */
	US_L,		/* registers */
	US_T,
	US_Z,
	US_Y,
	US_X,
	US_BOTTOMBAR,
	US_ENTRY,	/* data entry */
	US_PANE1,	/* function key panes */
	US_PANE2,
	};

/* -------------------- Globals -------------------- */

#if defined(BCD)
#define BCDDIGITS	12
#endif

	/* ---------- number format ---------- */
struct number {
	int type;		/* from units table */
	long i;			/* binary integer goes here */
#if defined(FLOAT)
	double f;		/* floating number goes here */
#endif
#if defined(BCD)
	int sign;		/* mantissa sign */
	int exp;		/* exponent */
	char digits[BCDDIGITS];	/* mantissa */
#endif
	};

enum FRACTYPE {
	FT_TOOLOW = 0,		/* fraction is too low */
	FT_EXACT = 1,		/* fraction is exact */
	FT_TOOHIGH = 2,		/* fraction is too high */
	};
	
	/* ---------- memory ---------- */

#define REGCOUNT	10
#define X		(REGCOUNT)
#define Y		(REGCOUNT + 1)
#define Z		(REGCOUNT + 2)
#define T		(REGCOUNT + 3)
#define L		(REGCOUNT + 4)
#define CLIP		(REGCOUNT + 5)
#define NUMSTACK	6
#define NUMREGS		(REGCOUNT + NUMSTACK)

struct memory {
	char ident[32];		/* identifier string */

	struct number r[NUMREGS];

	int cur_type;		/* current type */

	int word_size;		/* 1-32 */
	int compl_mode;		/* 0(u), 1, 2 */

	int frac_mode;		/* fraction mode */
	int frac_denom;		/* fraction denominator */

	FLAG stack_lift;
	int begnumlock;
	int endnumlock;
	int radix;

	int fkey_pane;
	int tab_spacing;
	FLAG hex_letters;
	FLAG show_types[UNIT_MAX];	/* which types are visible */

	char line[SMALLBUFFSIZE];	/* current entry */
	};

	/* cache of unit information */
struct unit {
	char *name;
	char *format;
	int cat;
	char *factors;
	int len;
	};

#if defined(MAIN)
struct memory m;			/* memory */
char fmt_buf[SMALLBUFFSIZE * 2];	/* buffer for U_Fmt */
long bin_mask;				/* word mask for binary operations */
struct unit units[UNIT_MAX];

	/* Arguments for commands.  Values have been coerced. */
struct number x;
struct number y;
struct number z;
struct number t;

KEYCODE key;		/* the current command key */
int table;		/* the current command table */

FLAG doabort;		/* do we leave the editor? */
FLAG was_num_lock;	/* was Num_Lock on? */

int num_units;
int num_panes;

int uarg;		/* command argument */
FLAG isuarg;		/* was there an argument? */

int redo;		/* for command to do again... */

int float_col;		/* where next floating menu goes */
int float_row;

char madefor;
KEYCODE ESC_swap;
KEYCODE CTX_swap;
char meta_handle;
char *ctype;
char *lower;
char *upper;
#else
extern struct memory m;
extern char fmt_buf[SMALLBUFFSIZE + 2];
extern long bin_mask;
extern struct unit units[UNIT_MAX];
extern struct number x;
extern struct number y;
extern struct number z;
extern struct number t;
extern KEYCODE key;
extern int table;
extern FLAG doabort;
extern FLAG was_num_lock;
extern int num_units;
extern int num_panes;
extern int uarg;
extern FLAG isuarg;
extern int redo;
extern int float_col;
extern int float_row;
extern char madefor;
extern KEYCODE ESC_swap;
extern KEYCODE CTX_swap;
extern char meta_handle;
extern char *ctype;
extern char *lower;
extern char *upper;
#endif

	/* terminal abstraction */
#if defined(MAIN)
int tattrnorm;		/* normal attribute */
int tattrrev;		/* reverse attribute */
int tattrru;		/* reverse,under attribute */
int tattrunder;		/* underscore attribute */
int tcol;		/* current col */
int tcols;		/* maximum col */
int toffset;		/* horizontal offset */
int trow;		/* current row */
int trows;		/* maximum row */
char tprintrep[] = {	/* print representation */
"\2^@ \2^A \2^B \2^C \2^D \2^E \2^F \2^G \
\2^H \2^I \2^J \2^K \2^L \2^M \2^N \2^O \
\2^P \2^Q \2^R \2^S \2^T \2^U \2^V \2^W \
\2^X \2^Y \2^Z \2^[ \2^\\ \2^] \2^^ \2^_ \
\1   \1!  \1\"  \1#  \1$  \1%  \1&  \1'  \
\1(  \1)  \1*  \1+  \1,  \1-  \1.  \1/  \
\1" "0  \1" "1  \1" "2  \1" "3  \1" "4  \1" "5  \1" "6  \1" "7  \
\1" "8  \1" "9  \1:  \1;  \1<  \1=  \1>  \1?  \
\1@  \1A  \1B  \1C  \1D  \1E  \1F  \1G  \
\1H  \1I  \1J  \1K  \1L  \1M  \1N  \1O  \
\1P  \1Q  \1R  \1S  \1T  \1U  \1V  \1W  \
\1X  \1Y  \1Z  \1[  \1\\  \1]  \1^  \1_  \
\1`  \1a  \1b  \1c  \1d  \1e  \1f  \1g  \
\1h  \1i  \1j  \1k  \1l  \1m  \1n  \1o  \
\1p  \1q  \1r  \1s  \1t  \1u  \1v  \1w  \
\1x  \1y  \1z  \1{  \1|  \1}  \1~  \2^? \
\3~^@\3~^A\3~^B\3~^C\3~^D\3~^E\3~^F\3~^G\
\3~^H\3~^I\3~^J\3~^K\3~^L\3~^M\3~^N\3~^O\
\3~^P\3~^Q\3~^R\3~^S\3~^T\3~^U\3~^V\3~^W\
\3~^X\3~^Y\3~^Z\3~^[\3~^\\\3~^]\3~^^\3~^_\
\2~  \2~! \2~\" \2~# \2~$ \2~% \2~& \2~' \
\2~( \2~) \2~* \2~+ \2~, \2~- \2~. \2~/ \
\2~0 \2~1 \2~2 \2~3 \2~4 \2~5 \2~6 \2~7 \
\2~8 \2~9 \2~: \2~; \2~< \2~= \2~> \2~? \
\2~@ \2~A \2~B \2~C \2~D \2~E \2~F \2~G \
\2~H \2~I \2~J \2~K \2~L \2~M \2~N \2~O \
\2~P \2~Q \2~R \2~S \2~T \2~U \2~V \2~W \
\2~X \2~Y \2~Z \2~[ \2~\\ \2~] \2~^ \2~_ \
\2~` \2~a \2~b \2~c \2~d \2~e \2~f \2~g \
\2~h \2~i \2~j \2~k \2~l \2~m \2~n \2~o \
\2~p \2~q \2~r \2~s \2~t \2~u \2~v \2~w \
\2~x \2~y \2~z \2~{ \2~| \2~} \2~~ \3~^?" };
#else
extern int tattrnorm;
extern int tattrrev;
extern int tattrru;
extern int tattrunder;
extern int tcol;
extern int tcols;
extern int toffset;
extern int trow;
extern int trows;
extern char tprintrep[];
#endif

/* -------------------- Routines -------------------- */

	/* larith.c */

void AAdd(void);
void AAnd(void);
void ACHS(void);
void AClear(void);
void ACubRt(void);
void ACube(void);
void ADiv(void);
void AEnter(void);
void AInv(void);
void ALast(void);
void AMul(void);
void ANeg(void);
void ANot(void);
void AOr(void);
void APercent(void);
void ARCL(void);
void ARoll(void);
FLAG ASame(struct number *a, struct number *b);
void ASLeft(void);
void ASRight(void);
void ASTO(void);
void ASqRt(void);
void ASquare(void);
void ASub(void);
void ASwap(void);
void AXor(void);
void AZero(struct number *a);

	/* lbcd.c */
#if defined(BCD)
void BAdd(struct number *a, struct number *b);
void BAssign(struct number *a, int n);
void BAssignI(struct number *a, int n);
void BAssignL(struct number *a, long n);
void BDiv(struct number *a, struct number *b);
FLAG BEnter(struct number *n, char *str);
FLAG BEqual(struct number *a, struct number *b);
void BFormat(char *buf, struct number *n);
FLAG BIsNeg(struct number *a);
FLAG BIsZero(struct number *a);
long BLong(struct number *a);
void BModf(struct number *n, struct number *f);
void BMul(struct number *a, struct number *b);
void BNeg(struct number *a);
void BSub(struct number *a, struct number *b);
#endif
	/* ldate.c */

void DDate(void);
long DDateN(long date, long amt);
long DDays(long date1, long date2);
void DNow(struct tm *tptr);
void DTime(void);

	/* ldisplay.c */

void DInit(void);
void DFini(void);
void DChanged(enum USES u);
void DChangedView(void);
void DClear(int start, int stop);
void DEcho(char *msg);
void DEchoNM(char *msg);
void DError(int msgnum);
void DErrorStr(char *msg);
int DFont(int new, FLAG doincr);
void DFormat(char *buf, struct number *nptr, char *which);
void DIncrDisplay(void);
void DLine(int line);
void DLine2(char *cptr, int row, int attr);
void DMenu(int which, int *rows, int *cols);
void DMenuSetup(int *rows, int *cols, char *hot_chars, int menu, int first,
	int number);
void DNewDisplay(void);
void DPostTime(void);
void DRowChar(int which);
void DRowChar2(int row, int which, int attr);
void DShow(char where, char *str, FLAG hilit);
void DView(char *msg);

	/* lfile.c */

void FEnvDefault(void);
void FEnvLoad(void);
FLAG FEnvSave(void);
void FNumL(int to);
#if defined(FCALLS)
FILE *FPathOpen(char *name, char *actualname);
#else
int FPathOpen(char *name, char *actualname);
#endif
FLAG FResLoad(char *file);
void FSave(void);

	/* lfrac.c */

void FDo(int *numerator, int *denominator, enum FRACTYPE *ft,
	struct number *n);
char *FFormat(struct number *n);
void FMode(void);
void FSetDenom(void);

	/* ljaguar.c */

#if defined(MSDOS)
void JInit(void);
void JFini(void);
void JDisEnd(void);
void JDisStart(void);
KEYCODE JGetKey(void);
char JIsKey(void);

#if defined(SYSMGR)
void JCopy(void);
void JGetDir(char *dname);
FLAG JPaste(void);
#endif
#endif

	/* lkey.c */

int KAsk(int msgnum);
void KBegMac(void);
FLAG KDelayPrompt(int msgnum);
void KColon(void);
void KEndMac(void);
void KFromMac(void);
void KFromStr(char *str, int len);
KEYCODE KGetChar(void);
int KGetStr(int msgnum, char *str, int len);
int KGetStr2(char *msg, char *str, int len);
char KIsKey(void);
void KLoadMac(void);
void KMacDo(int table, int offset, FLAG incr);
char KMacIs(void);
KEYCODE *KMacPtr(void);
void KMacRec(KEYCODE key);
void KMenu(int which);
void KMenuDo(int menu, int entry);
void KMenuMac(void);
void KPush(KEYCODE key);
FLAG KUArg(int targ);

	/* lmisc.c */

void CCharBD(void);
int ConvUpper(int chr);
void MAbort(void);
void MAbout(void);
void MAll(void);
void MBinFix(void);
void MClear(void);
void MClearStk(void);
void MClearX(void);
void MCompl(void);
void MConv(void);
void MCopy(void);
void MCtrlX(void);
void MCut(void);
void MDoKey(void);
void MEnter(void);
void MEnterASCII(void);
void MExit(void);
void MFont(void);
void MInsChar(void);
void MHexLetters(void);
void MMacEval(void);
void MNotImpl(void);
void MNumBeg(void);
void MNumEnd(void);
void MMenu(void);
void MMenuM(void);
void MMeta(void);
void MPane(void);
void MPaneKey(void);
void MPaste(void);
void MQuote(void);
void MRadix(void);
void MRegisters(void);
void MSetTabs(void);
void MShow(void);
void MSpace(void);
void MStatus(void);
FLAG MSToNL(char *str, long *n, int base);
void MType(void);
void MUArg(void);
void MWSize(void);

	/* ltable.c */

void TabDispatch(KEYCODE key, int table);
void TabDo(int code);
int TabGetCmdID(KEYCODE key, int table);
int TabTable(KEYCODE key, int table);

	/* lterm.c */

#define TAttrNorm()	(tattrnorm)
#define TAttrRev()	(tattrrev)
#define TAttrRU()	(tattrru)
#define TAttrUnder()	(tattrunder)
#define TGetCol()	(tcol)
#define TGetOffset()	(toffset)
#define TGetRow()	(trow)
#define TGetWidth(c)	(tprintrep[(c & 0xFF) * 4])
#define TGetTabWidth(col) (m.tab_spacing - ((col) % m.tab_spacing))
#define TMaxCol()	(tcols)
#define TMaxRow()	(trows)

FLAG TInit(void);
void TFini(void);
void TAttrBlock(char *data, int count, FLAG doclear, int clearattr);
void TBell(void);
void TCLEOL(void);
void TClrScreen(void);
void TCurOff(void);
void TCurOn(void);
void TForce(void);
KEYCODE TGetKey(void);
void THiOff(void);
void THiOn(void);
FLAG TIsKey(void);
char *TPrintChar(char c);
void TPutChar(char c);
char *TPutCharBuf(char c, int col);
void TPutStr(char *str);
void TSetOffset(int col, int offset);
void TSetPoint(int row, int column);

	/* lunits.c */

FLAG UEnter(struct number *a, char *str, int type);
FLAG UEnterNum(struct number *a, char *str, int type);
void UFormat(char *buf, int type, struct number *nptr);
FLAG UIsBin(int type);
void UToBin(struct number *a);
void UToType(int type, struct number *a);
void UPromote1(struct number *a, int amt);
void UPromote2(struct number *a, struct number *b, int amt);

	/* lxprintf.c */

#if defined(VARARGS)
#if defined(__STDC__)
void xsprintf(char *string, char *fmt, ...);
#else
void xsprintf();		/* char *string, char *fmt, ... */
#endif
#endif

/* end of LOKI.H -- Loki Header File */
