/* LARITH.C -- Arithemtic Commands

	Written April 1994 by Craig A. Finseth
	Copyright 1994 by Craig A. Finseth
*/

#define CAT_DIST	2
#define CAT_TIME	7
#define CAT_SPEED	10
#define CAT_DATA	11
#define CAT_DATAR	12

#include "loki.h"
#if defined(FLOAT)
#include <math.h>
#endif

/* ------------------------------------------------------------ */

/* Add two numbers. */

void
AAdd(void)
	{
	UToType(y.type, &x);
	if (UIsBin(y.type)) {
		x.i += y.i;
		x.i &= bin_mask;
		}
	else if (y.type == (RES_UN_DATE / UNIT_SIZE)) {
		UToBin(&y);
		UToBin(&x);
		x.type = RES_UN_DATE / UNIT_SIZE;
#if defined(FLOAT)
		x.f = DDateN(y.i, x.i);
#endif
#if defined(BCD)
		BAssignL(&x, DDateN(y.i, x.i));
#endif
		}
	else	{
#if defined(FLOAT)
		x.f += y.f;
#endif
#if defined(BCD)
		BAdd(&x, &y);
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Bitwise And. */

void
AAnd(void)
	{
	UToBin(&x);
	UToBin(&y);
	x.i &= y.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Change Sign. */

void
ACHS(void)
	{
	char *cptr;
	int len = strlen(m.line);

/* is it on the command line? */
	if (len > 0) {
		if (len >= sizeof(m.line) - 1) {
			TBell();
			return;
			}

		if (*(cptr = sfindin(m.line, "eE")))
			cptr++;
		else	cptr = m.line;

		if (*cptr == '-') {
			xstrcpy(cptr, cptr + 1);
			}
		else	{
			memmove(cptr + 1, cptr, strlen(cptr) + 1);
			*cptr = '-';
			}
		DChanged(US_ENTRY);
		}
	else	{
		redo = RES_ANEG;
		}
	}


/* ------------------------------------------------------------ */

/* Clear a memory.  */

void
AClear(void)
	{
	KEYCODE key;

	if (KIsKey() == 'Y') {
		key = KGetChar();
		}
	else	{
		do	{
			DEcho(Res_String(NULL, RES_MSGS, RES_CLEARPROMPT));
			} while ((key = KGetChar()) == KEYREGEN);
		}
	if (!xisdigit(key)) key = '0';
	AZero(&m.r[key - '0']);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Cube Root. */

void
ACubRt(void)
	{
#if defined(FLOAT)
	double new1;
	double new2;
	double diff;
#endif
#if defined(BCD)
	struct number new1;
	struct number new2;
	struct number diff;
	struct number two;
	struct number smallenough;
	int type;
#endif

	if (UIsBin(x.type)) UToType(RES_UN_NONE / UNIT_SIZE, &x);
	UPromote1(&x, -2);

#if defined(FLOAT)
	new1 = 0.0;
	new2 = x.f;
	do	{
		new1 = (new1 + new2) / 2;
		new2 = (x.f / new1) / new1;
		diff = (new1 - new2) / new2;
		if (diff < 0.0) diff = -diff;
		} while (diff > 1.0e-9);
	x.f = new1;
#endif
#if defined(BCD)
	BAssign(&new1, 0);
	BAssign(&two, 2);
	BEnter(&smallenough, "1e-9");
	new2 = x;
	type = x.type;
	do	{
		BAdd(&new1, &new2);
		BDiv(&new1, &two);

		new2 = x;
		BDiv(&new2, &new1);
		BDiv(&new2, &new1);

		diff = new1;
		BSub(&diff, &new2);
		BDiv(&diff, &new2);

		if (BIsNeg(&diff)) BNeg(&diff);

		BSub(&diff, &smallenough);
		} while (!BIsNeg(&diff));
	x = new1;
	x.type = type;
#endif
	}


/* ------------------------------------------------------------ */

/* Cube. */

void
ACube(void)
	{
#if defined(BCD)
	struct number tmp;
#endif

	if (UIsBin(x.type)) {
		x.i = x.i * x.i * x.i;
		x.i &= bin_mask;
		}
	else	{
		UPromote1(&x, 2);
#if defined(FLOAT)
		x.f = x.f * x.f * x.f;
#endif
#if defined(BCD)
		tmp = x;
		BMul(&x, &tmp);
		BMul(&x, &tmp);
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Divide. */

void
ADiv(void)
	{
	if (UIsBin(y.type)) {
		UToType(y.type, &x);
		if (x.i == 0) {
			DError(RES_CALCDIVZERO);
			x.i = 1;
			}
		x.i = y.i / x.i;
		x.i &= bin_mask;
		return;
		}

#if defined(FLOAT)
	if (x.f == 0.0) {
		DError(RES_CALCDIVZERO);
		x.f = 1.0;
		}
#endif
	if (units[y.type].cat == CAT_DIST &&
		 units[x.type].cat == CAT_TIME) {
		UToType(RES_UN_M / UNIT_SIZE, &y);
#if defined(FLOAT)
		y.f /= x.f;
#endif
#if defined(BCD)
		BDiv(&y, &x);
#endif
		x = y;
		UToType(RES_UN_MPS / UNIT_SIZE, &x);		
		}
	else if (units[y.type].cat == CAT_DATA &&
		 units[x.type].cat == CAT_TIME) {
		UToType(RES_UN_BIT / UNIT_SIZE, &y);
#if defined(FLOAT)
		y.f /= x.f;
#endif
#if defined(BCD)
		BDiv(&y, &x);
#endif
		x = y;
		UToType(RES_UN_BPS / UNIT_SIZE, &x);		
		}
	else	{
		UPromote2(&y, &x, -1);
#if defined(FLOAT)
		y.f /= x.f;
#endif
#if defined(BCD)
		BDiv(&y, &x);
#endif
		x = y;
		}
	}


/* ------------------------------------------------------------ */

/* Handle the Enter function. */

void
AEnter(void)
	{
	y = x;
	m.stack_lift = TRUE;
	}


/* ------------------------------------------------------------ */

/* Inverse, 1/x. */

void
AInv(void)
	{
#if defined(BCD)
	struct number tmp;
#endif

	if (UIsBin(x.type)) {
		x.i = 0;
		}
	else	{
#if defined(FLOAT)
		if (x.f == 0.0) {
			DError(RES_CALCDIVZERO);
			x.f = 1.0;
			}
		x.f = 1.0 / x.f;
#endif
#if defined(BCD)
		BAssign(&tmp, 1);
		tmp.type = x.type;
		BDiv(&tmp, &x);
		x = tmp;
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Recall Last X. */

void
ALast(void)
	{
	x = m.r[L];
	}


/* ------------------------------------------------------------ */

/* Multiply. */

void
AMul(void)
	{
	if (UIsBin(y.type)) {
		UToType(y.type, &x);
		x.i *= y.i;
		x.i &= bin_mask;
		return;
		}

	if (units[y.type].cat == CAT_SPEED &&
		 units[x.type].cat == CAT_TIME) {
		UToType(RES_UN_MPS / UNIT_SIZE, &y);
#if defined(FLOAT)
		y.f *= x.f;
#endif
#if defined(BCD)
		BMul(&y, &x);
#endif
		x = y;
		UToType(RES_UN_M / UNIT_SIZE, &x);		
		}
	else if (units[x.type].cat == CAT_SPEED &&
		 units[y.type].cat == CAT_TIME) {
		UToType(RES_UN_MPS / UNIT_SIZE, &x);
#if defined(FLOAT)
		y.f *= x.f;
#endif
#if defined(BCD)
		BMul(&y, &x);
#endif
		x = y;
		UToType(RES_UN_M / UNIT_SIZE, &x);		
		}
	else if (units[y.type].cat == CAT_DATAR &&
		 units[x.type].cat == CAT_TIME) {
		UToType(RES_UN_BPS / UNIT_SIZE, &y);
#if defined(FLOAT)
		y.f *= x.f;
#endif
#if defined(BCD)
		BMul(&y, &x);
#endif
		x = y;
		UToType(RES_UN_BIT / UNIT_SIZE, &x);		
		}
	else if (units[x.type].cat == CAT_DATAR &&
		 units[y.type].cat == CAT_TIME) {
		UToType(RES_UN_BPS / UNIT_SIZE, &x);
#if defined(FLOAT)
		y.f *= x.f;
#endif
#if defined(BCD)
		BMul(&y, &x);
#endif
		x = y;
		UToType(RES_UN_BIT / UNIT_SIZE, &x);		
		}
	else	{
		UPromote2(&y, &x, 1);
#if defined(FLOAT)
		y.f *= x.f;
#endif
#if defined(BCD)
		BMul(&y, &x);
#endif
		x = y;
		}
	}


/* ------------------------------------------------------------ */

/* Negate. */

void
ANeg(void)
	{
	if (UIsBin(x.type)) {
		x.i = -x.i;
		x.i &= bin_mask;
		}
	else	{
#if defined(FLOAT)
		x.f = -x.f;
#endif
#if defined(BCD)
		BNeg(&x);
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Binary Not. */

void
ANot(void)
	{
	UToBin(&x);
	x.i = ~x.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Binary Or. */

void
AOr(void)
	{
	UToBin(&x);
	UToBin(&y);
	x.i |= y.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Percentage. */

void
APercent(void)
	{
#if defined(BCD)
	struct number tmp;
	struct number tmpy;
#endif

	UToType(y.type, &x);
	if (UIsBin(y.type)) {
		x.i *= y.i;
		x.i /= 100;
		x.i &= bin_mask;
		}
	else	{
#if defined(FLOAT)
		x.f *= y.f / 100.0;
#endif
#if defined(BCD)
		tmpy = y;
		BAssignI(&tmp, 100);
		BDiv(&tmpy, &tmp);
		BMul(&x, &tmpy);
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Recall. */

void
ARCL(void)
	{
	char buf[LINEBUFFSIZE];
	KEYCODE key;
	int cmd;
	struct number tmpy;

	if (KIsKey() == 'Y') {
		key = KGetChar();
		}
	else	{
		do	{
			DEcho(Res_String(NULL, RES_MSGS, RES_RECALLPROMPT));
			} while ((key = KGetChar()) == KEYREGEN);
		}

	cmd = TabGetCmdID(key, 0);
	if (strequ(Res_String(NULL, RES_FUNCID, cmd), "E21LE")) {
		if (KIsKey() == 'Y') {
			key = KGetChar();
			}
		else	{
			do	{
				DEcho(Res_String(NULL, RES_MSGS, RES_RECALLPROMPT));
				} while ((key = KGetChar()) == KEYREGEN);
			}
		}
	else	{
		cmd = RES_UNKCMD;
		}

	if (!xisdigit(key)) key = '0';

	if (cmd == RES_UNKCMD) {
		y = x;
		x = m.r[key - '0'];
		}
	else	{
		tmpy = y;
		y = x;
		x = m.r[key - '0'];
		TabDo(cmd);
		y = tmpy;
		}
	m.stack_lift = TRUE;
	}


/* ------------------------------------------------------------ */

/* Roll Down. */

void
ARoll(void)
	{
	struct number tmp;

	tmp = m.r[X];
	m.r[X] = m.r[Y];
	m.r[Y] = m.r[Z];
	m.r[Z] = m.r[T];
	m.r[T] = tmp;
	}


/* ------------------------------------------------------------ */

/* Tell if the two numbers are the same. */

FLAG
ASame(struct number *a, struct number *b)
	{
	if (a->type != b->type) return(FALSE);
	if (UIsBin(a->type)) {
		return(a->i == b->i);
		}
	else	{
#if defined(FLOAT)
		return(a->f == b->f);
#endif
#if defined(BCD)
		return(BEqual(a, b));
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Shift Left. */

void
ASLeft(void)
	{
	UToBin(&x);
	UToBin(&y);
	x.i = y.i << x.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Square Root. */

void
ASqRt(void)
	{
#if defined(FLOAT)
#if !defined(BUILTIN)
	double new1;
	double new2;
	double diff;
#endif
#endif
#if defined(BCD)
	struct number new1;
	struct number new2;
	struct number diff;
	struct number two;
	struct number smallenough;
	int type;
#endif

	if (UIsBin(x.type)) UToType(RES_UN_NONE / UNIT_SIZE, &x);
	UPromote1(&x, -1);

#if defined(FLOAT)
	if (x.f < 0.0) {
		DError(RES_CALCNEG);
		x.f = 0.0;
		return;
		}
#if defined(BUILTIN)
	x.f = sqrt(x.f);
#else
	new1 = 0.0;
	new2 = x.f;
	do	{
		new1 = (new1 + new2) / 2;
		new2 = x.f / new1;
		diff = (new1 - new2) / new2;
		if (diff < 0.0) diff = -diff;
		} while (diff > 1.0e-9);
	x.f = new1;
#endif
#endif
#if defined(BCD)
	if (BIsNeg(&x)) {
		DError(RES_CALCNEG);
		BAssign(&x, 0);
		return;
		}
	BAssign(&new1, 0);
	BAssign(&two, 2);
	BEnter(&smallenough, "1e-9");
	new2 = x;
	type = x.type;
	do	{
		BAdd(&new1, &new2);
		BDiv(&new1, &two);

		new2 = x;
		BDiv(&new2, &new1);

		diff = new1;
		BSub(&diff, &new2);
		BDiv(&diff, &new2);

		if (BIsNeg(&diff)) BNeg(&diff);

		BSub(&diff, &smallenough);
		} while (!BIsNeg(&diff));
	x = new1;
	x.type = type;
#endif
	}


/* ------------------------------------------------------------ */

/* Square. */

void
ASquare(void)
	{
#if defined(BCD)
	struct number tmp;
#endif
	if (UIsBin(x.type)) {
		x.i *= x.i;
		x.i &= bin_mask;
		}
	else	{
		UPromote1(&x, 1);
#if defined(FLOAT)
		x.f *= x.f;
#endif
#if defined(BCD)
		tmp = x;
		BMul(&x, &tmp);
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Shift Right. */

void
ASRight(void)
	{
	UToBin(&x);
	UToBin(&y);
	x.i = y.i >> x.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Store. */

void
ASTO(void)
	{
	char buf[LINEBUFFSIZE];
	KEYCODE key;
	int cmd;
	struct number tmpy;
	struct number tmpx;

	if (KIsKey() == 'Y') {
		key = KGetChar();
		}
	else	{
		do	{
			DEcho(Res_String(NULL, RES_MSGS, RES_STOREPROMPT));
			} while ((key = KGetChar()) == KEYREGEN);
		}

	cmd = TabGetCmdID(key, 0);
	if (strequ(Res_String(NULL, RES_FUNCID, cmd), "E21LE")) {
		if (KIsKey() == 'Y') {
			key = KGetChar();
			}
		else	{
			do	{
				DEcho(Res_String(NULL, RES_MSGS, RES_STOREPROMPT));
				} while ((key = KGetChar()) == KEYREGEN);
			}
		}
	else	{
		cmd = RES_UNKCMD;
		}

	if (!xisdigit(key)) key = '0';

	if (cmd == RES_UNKCMD) {
		m.r[key - '0'] = x;
		}
	else	{
		tmpy = y;
		tmpx = x;
		y = m.r[key - '0'];
		TabDo(cmd);
		y = tmpy;
		m.r[key - '0'] = x;
		x = tmpx;
		}
	}


/* ------------------------------------------------------------ */

/* Subtract. */

void
ASub(void)
	{
	UToType(y.type, &x);
	if (UIsBin(y.type)) {
		x.i = y.i - x.i;
		x.i &= bin_mask;
		}
	else if (y.type == (RES_UN_DATE / UNIT_SIZE)) {
		if (x.type == (RES_UN_DATE / UNIT_SIZE)) {
			UToBin(&y);
			UToBin(&x);
			x.type = RES_UN_DATE / UNIT_SIZE;
#if defined(FLOAT)
			x.f = DDays(y.i, x.i);
#endif
#if defined(BCD)
			BAssignL(&x, DDays(y.i, x.i));
#endif
			}
		else	{
			UToType(RES_UN_DATE / UNIT_SIZE, &x);
#if defined(FLOAT)
			x.f = y.f - x.f;
#endif
#if defined(BCD)
			BSub(&y, &x);
			x = y;
#endif
			}
		}
	else	{
#if defined(FLOAT)
		x.f = y.f - x.f;
#endif
#if defined(BCD)
		BSub(&y, &x);
		x = y;
#endif
		}
	}


/* ------------------------------------------------------------ */

/* Swap X and Y. */

void
ASwap(void)
	{
	struct number tmp;

	tmp = y;
	y = x;
	x = tmp;
	}


/* ------------------------------------------------------------ */

/* Binary Xor. */

void
AXor(void)
	{
	UToBin(&x);
	UToBin(&y);
	x.i ^= y.i;
	x.i &= bin_mask;
	}


/* ------------------------------------------------------------ */

/* Zero a number. */

void
AZero(struct number *a)
	{
	a->type = m.cur_type;

	a->i = 0;
#if defined(FLOAT)
	a->f = 0.0;
#endif
#if defined(BCD)
	BAssign(a, 0);
#endif
	}


/* end of LARITH.C -- Arithemtic Commands */
