/* --------------------------------------------------------------------
   Project: PAL: Palmtop Application Library
   Module:  WINTEXT.C
   Author:  Gilles Kohl
   Started: 10. Nov. 94
   Modified: 11. Aug. 99 (Jean-Jacques Moreau)
   Subject: Output text in client area of a window
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                            msdos includes
   -------------------------------------------------------------------- */
#include <dos.h>

/* --------------------------------------------------------------------
                           local includes
   -------------------------------------------------------------------- */
#include "pal.h"
#include "palpriv.h"

/* --------------------------------------------------------------------
                           Functions
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
   WinText:
   Output a text string at position (x,y) in client area of a window
   given by a pointer to a PALWIN descriptor.
   -------------------------------------------------------------------- */

void WinText(PALWIN *pWin, int OffsetX, int OffsetY, char *Txt)
{
   WriteText(pWin->PosX+OffsetX, pWin->PosY+OffsetY, Txt);
}

/* --------------------------------------------------------------------
   WinTextAlignH:
   Output a text string at position (x, y) in client area of a window
   given by a pointer to a PALWIN descriptor, where x is automatically
   determined using the text font id and alignment style.
   -------------------------------------------------------------------- */

void WinTextAlignH(PALWIN *pWin, int OffsetY, char *Txt, int FontId, int Style)
{
   if (Style == TAS_LEFT)
      WinText(pWin, 0, OffsetY, Txt);
   else if (Style == TAS_RIGHT)
      WinText(pWin, pWin->Width-TextExt(FontId, Txt), OffsetY, Txt);
   else if (Style == TAS_CENTER)
      WinText(pWin, pWin->Width/2-TextExt(FontId, Txt)/2, OffsetY, Txt);
}

/* --------------------------------------------------------------------
   WinLine:
   Draw a line between two endpoints (x1,y1) and (x2,y2) in client area
   of a window given by a pointer to a PALWIN descriptor.
   -------------------------------------------------------------------- */

void WinLine(PALWIN *pWin, int OffsetX1, int OffsetY1, int OffsetX2, int OffsetY2)
{
   Line(pWin->PosX+OffsetX1, pWin->PosY+OffsetY1, pWin->PosX+OffsetX2, pWin->PosY+OffsetY2);
}


