Polymath Class Tabular Local

   Integer variable   N
   Real    array(300) xx
   Real    array(300) yy
   Real    variable   xold
   Real    variable   yold

   Integer variable   CodeLogx
   Integer variable   CodeLogy
   Integer variable   CodeExpy

   Integer  Variable     Power  \ Power of the polynomial
   Integer  Variable     MP     \ Maximum power of the polynomial (max = 5)
   Integer  Variable     NEQ    \ Number of equations = MP+1
   Real     Array(11,12) A      \ Assembly of simultaneous equations


---

: Logx execute(CodeLogX) ;
: Logy execute(CodeLogY) ;
: Expy execute(CodeExpY) ;

: Writing
  If(n=300)
     Message('The segment is full.')
     Stop(true)
  else
     N+1 --> N
         --> yy(n)
         --> xx(n)
  endif;

: Initialize { Lx Ly Ey }
  0   --> N
  Lx  --> CodeLogX
  Ly  --> CodeLogY
  Ey  --> CodeExpY ;

Global

: @ { x }
  1   { i1 }
  n/2 { i2 }
  n   { i3 }
  begin
     int((i1+i3)/2)  { i2 }
     If( xx(i2)<x )
        i2 --> i1
     else
        i2 --> i3
     endif
  until((i3-i1)=1)

  xx(i1)  logx { x1 }
  xx(i3)  logx { x2 }
  yy(i1)  logy { y1 }
  yy(i3)  logy { y2 }

  expy( (y2-y1)*(x-x1)/(x2-x1)  +y1 ) ;

: Clear 0 --> N ;

: range
  xx(1) xx(n)
  yy(1) dup  { yn yx }
  Do(2,n)
     Max(yx,yy(i)) --> yx
     Min(yn,yy(i)) --> yn
  Loop
  yn yx ;

: Show
  Do(1,N)
     String(xx(i)),Justify(15)
     String(yy(i)),Justify(15) &
     Message
  Loop;

Polymath definitions

\ -------------------------------------------
\            LogX        LogY        ExpY
\ -------------------------------------------

: LogLog  Find("Ln")  Find("Ln")  Find("Exp") ;
: LogLin  Find("Ln")  0           0           ;
: LinLog  0           Find("Ln")  Find("Exp") ;
: LinLin  0           0           0           ;

\ ***************************************************

Tabular Definitions

Local

Real     Array(21)  SX      \ Storage for summations of X
Real     Array(11)  SY      \ Storage for summations of X & Y
Real     Variable   x       \ x - the independent variable
Integer  Variable   D       \ Derivative of the polynomial

Integer  Variable II
Integer  Variable JJ
Integer  Variable KK
Real     Variable T


\ ----------  Display the coefficients   ----------

: C  ># #> A(1+,NEQ+1)   ;  \ Return the i-th coefficient

Global
: Coef
  Nfix { n }
  Do(Power,0)
     ('C(')
     &String(fix(0),i)
     &(')') Tab(6)
     &(' = ')
     &(String(fix(n),C(i)), Justify(10))
     Message
  iloop(--1) ;

\ ----------   Initialize the Matrices   ----------
Local
: ClearSX  Do(1,MP*2+1)   0 --> SX(I)   Loop ;

: ClearSY  Do(1,MP+1)     0 --> SY(I)   Loop ;

: ClearA
  Do(1,MP)
     Do(1,MP+1)
        0 --> A(j,i)
     Loop
  Loop ;

\ ----------   Solve the simultaneous equations   ----------

: with i --> ;

: SayForward nfix { n }
  View(('Forward - ') &String(fix(0))) n --> nfix;

: SayBackward nfix { n }
  View(('Backward - ') &String(fix(0))) n --> nfix;

: Forward
  Do(1,neq) with ii
     SayForward(ii)
     Do(ii+1,neq) with jj
        If(ii+1 <=Neq)
           A(jj,ii)/A(ii,ii)  -->  T
           Do(ii,neq+1) with kk
              A(jj,kk)-(T*A(ii,kk))  -->  A(jj,kk)
           Loop
        Endif
     Loop
  Loop ;

: InnerLoop   0 --> T
  Return(jj>=neq)
  Do(jj+1,neq) with kk
     T+(A(jj,kk)*C(kk-1))  -->  T
  Loop ;

: Backward
  Do(neq,1) with jj
     SayBackward(jj)
     InnerLoop
     (C(jj-1)-T)/A(jj,jj)  -->  C(jj-1)
  iloop(--1) ;

: Solve Forward Backward ;

\ ----------   Assemble matrix of simultaneous equations   ----------

: AssembleColumn { col }
  Do(1,neq)
     SX(i+col-1) --> A(i,col)
  Loop ;

: AssembleY
  Do(1,neq)
     SY(i) --> A(i,neq+1)
  Loop ;

: Assemble
  Power+1 --> NEQ
  Do(1,neq)
     AssembleColumn(i)
  Loop
  AssembleY;


\ ----------   Accumulate summations of x & y products   ----------

: AccumY
  Do(1,MP+1)
     Dup+SY(I) --> SY(I)
     Over *
  Loop
  Drop Drop ;

: AccumX   1
  Do(1,MP*2+1)
     Dup+SX(I) --> SX(I)
     Over *
  Loop
  Drop Drop ;

: Factor fact(dup)/fact(swap-D);

Global
: F
  C(power)*Factor(power)
  Do(power-1,D)
     *(over)+(C(i)*Factor(i))
  iLoop(--1) swap drop ;

: Regress  --> power  power  --> mp
  ClearSX  ClearSY  ClearA
  Do(1,n)
     xx(i) dup yy(i) AccumY AccumX
  Loop
  Assemble
  Solve
  Coef;

: PlotTab
  If(GraphicsMode=0)
     Range { x1 x2 y1 y2 }
     If(codelogx<>0) 0 else 5 endif { xd }
     If(codeLogy<>0) 0 else 5 endif { yd }
     Divisions(xd,yd)
     Xscale(x1,x2) Xaxis
     Yscale(y1,y2) Yaxis DrawAxes
  endif
  Move(xx(1),yy(1))
  Do(2,n)
     draw(xx(i),yy(i))
  Loop;

polymath definitions

LinLin Tabular variable normal

Local

: !
  11 roll 100 * { z }
  do(0,9)
     (z+i)/100  (11-i) roll --> normal
  Loop ;

0.0 .5000 .4960 .4920 .4880 .4840 .4801 .4761 .4721 .4681 .4641 !
0.1 .4602 .4562 .4522 .4483 .4443 .4404 .4364 .4325 .4286 .4247 !
0.2 .4207 .4168 .4129 .4090 .4052 .4013 .3974 .3936 .3897 .3859 !
0.3 .3821 .3783 .3745 .3707 .3669 .3632 .3594 .3557 .3520 .3483 !
0.4 .3446 .3409 .3372 .3336 .3300 .3264 .3228 .3192 .3156 .3121 !
0.5 .3085 .3050 .3015 .2981 .2946 .2912 .2877 .2843 .2810 .2776 !

0.6 .2743 .2709 .2676 .2643 .2611 .2578 .2546 .2514 .2483 .2451 !
0.7 .2420 .2389 .2358 .2327 .2297 .2266 .2236 .2206 .2177 .2148 !
0.8 .2119 .2090 .2061 .2033 .2005 .1977 .1949 .1922 .1894 .1867 !
0.9 .1841 .1814 .1788 .1762 .1736 .1711 .1685 .1660 .1635 .1611 !
1.0 .1587 .1562 .1539 .1515 .1492 .1469 .1446 .1423 .1401 .1379 !

1.1 .1357 .1335 .1314 .1292 .1271 .1251 .1230 .1210 .1190 .1170 !
1.2 .1151 .1131 .1112 .1093 .1075 .1056 .1038 .1020 .1003 .0985 !
1.3 .0968 .0951 .0934 .0918 .0901 .0885 .0869 .0853 .0838 .0823 !
1.4 .0808 .0793 .0778 .0764 .0749 .0735 .0722 .0708 .0694 .0681 !
1.5 .0668 .0655 .0643 .0630 .0618 .0606 .0594 .0582 .0570 .0559 !

1.6 .0548 .0537 .0526 .0516 .0505 .0495 .0485 .0475 .0465 .0455 !
1.7 .0446 .0436 .0427 .0418 .0409 .0401 .0392 .0384 .0375 .0367 !
1.8 .0359 .0352 .0344 .0336 .0329 .0322 .0314 .0307 .0300 .0294 !
1.9 .0287 .0281 .0274 .0268 .0262 .0256 .0250 .0244 .0238 .0233 !
2.0 .0228 .0222 .0217 .0212 .0207 .0202 .0197 .0192 .0188 .0183 !

2.1 .0179 .0174 .0170 .0166 .0162 .0158 .0154 .0150 .0146 .0143 !
2.2 .0139 .0136 .0132 .0129 .0126 .0122 .0119 .0116 .0113 .0110 !
2.3 .0107 .0104 .0102 .0099 .0096 .0094 .0091 .0089 .0087 .0084 !
2.4 .0082 .0080 .0078 .0075 .0073 .0071 .0069 .0068 .0066 .0064 !
2.5 .0062 .0060 .0059 .0057 .0055 .0054 .0052 .0051 .0049 .0048 !

2.6 .0047 .0045 .0044 .0043 .0041 .0040 .0039 .0038 .0037 .0036 !
2.7 .0035 .0034 .0033 .0032 .0031 .0030 .0029 .0028 .0027 .0026 !
2.8 .0026 .0025 .0024 .0023 .0023 .0022 .0021 .0021 .0020 .0019 !
2.9 .0019 .0018 .0017 .0017 .0016 .0016 .0015 .0015 .0014 .0014 !

Localize

: Startup
  Compile Tabular
  1 --> keyset
  Blk("Tab")
  1 assign("PlotTab")
  2 assign("Regress")
  3 assign("F")
  4 assign("@")
  5 assign("Coef")
  6 assign("Show")
  Normal
  Compile Polymath
  explanation ; invisible

\ ---------------------------------------------------------------

Tabular

Document Startup
                            TABULAR FUNCTIONS

This application program provides a handy tool for handling tabular data.
After creating a tabular variable, x & y values are then written to the
variable.  The variable then behaves like a function.  Supplied with an x-
value, the table is searched for bracketing values of x.  The corresponding
y-value is then determined by interpolation.

Interpolation may be linear or logarithmic for either the x or y values.
This is determined when the variable is first defined.  Here are some
examples,

                        LinLin Tabular variable x
                        LinLog Tabular variable y
                        LogLog Tabular variable z
.break
Data is entered into a tabular variable just as it is for any other variable.
You need to supply both an x & y value, however.  And, it is assumed that
values of x are monotonically increasing.  The following example shows how
data is entered:

                              1  1 --> y
                             10 10 --> y
                             50 10 --> y
                            100  3 --> y

Once data has been entered into the variable, a number of things may then be
done with it.  The variable may be evaluated as follows:

                       y( 1) @   ==>  1.0000
                       y( 2) @   ==>  1.2915
                       y(70) @   ==>  6.1780
.break
A plot of the contents of the tabular variable is obtained with PLOTTAB.
Axes will be scaled according to the type of interpolation that was
specified.  For example, to obtain a plot of Y:

                              y PlotTab

The plot will be automatically scaled.  Since Y was declared to be LINLOG,
the plot will have a linear x-axis and a log y-axis.
.break
                              REGRESSION

Another option that is available is to perform a least squares regression
analysis on the contents of the variable.  Coefficients for a polynomial (up
to a maximum power of 10) are calculated as follows:

                             y  regress(3)

This will calculate coefficients for a cubic polynomial.  The polynomial is
evaluated with the function F.  For example,

                            f(1) f(2) f(3) ...
.break
                     GAUSSIAN NORMAL DISTRIBUTION

The Gaussian normal probability distribution has already been compiled
into a table as an example.  This tabular variable is called NORMAL.  For a
corresponding value of z, the probability value that is returned is the area
under the curve to the right of the z-value.$

Document Clear
Clear ( --- )

Clear out the contents of a tabular variable.$

Document Show
Show ( --- )

Display the contents of a tabular variable to the message board.$

Document Coef
Coef  ( --- )

Display the coefficients which were last calculated by REGRESS.$

Document F
F  ( x --- y )

Evaluate the current polynomial.  The current polynomial is calculated
by REGRESS after x & y values have been entered into a tabular
variable.$

Document @
@  ( x --- y )

Evaluate the tabular variable at x.  The data is searched for bracketing
values of x, and the corresponding value of y is then found by
interpolation.$

Document Regress
Regress  ( power --- )

Calculate the coefficients for a polynomial which is a least squares
best fit of the data contained in a tabular variable.  The power of the
polynomial which is to be determined is taken from the stack.$

Document PlotTab
PlotTab  ( --- )

The contents of the tabular variable are plotted.$

Document LinLin
LinLin  ( --- )

Interpolation between points in a tabular variable will be done by linear
interpolation.$

Document LogLin
LogLin  ( --- )

Interpolation between points in a tabular variable will be done by log
interpolation on the x-axis and linear interpolation on the y-axis.$

Document LinLog
LinLog  ( --- )

Interpolation between points in a tabular variable will be done by log
interpolation on the y-axis and linear interpolation on the x-axis.$

Document LogLog
LogLog  ( --- )

Interpolation between points in a tabular variable will be done by
logarithmic interpolation along both axes.$

Document Normal
Normal  ( z --- p )

Tabular variable containing values for the Gaussian normal probability
distribution.  For a corresponding value of z, the probability value that is
returned is the area under the curve to the right of the z-value.$

