#include <stdio.h>
#include <stdlib.h>

#include "pal.h"
#include "icnsavrc.h"

APPDESC *pAd;

char *AppCb(int i)
{
   static char buf[80];
   char Title[80];

   GetAppDef(pAd, i, Title, NULL, NULL, NULL, NULL, NULL);
   sprintf(buf, " %-15.15s", Title);
   return buf;
}


void main(void)
{
   IMGHDR *pImg;
   int  Count, Xpos, Ypos;
   WORD Key;
   WORD HomeKey[] = { HOME_KEY, 0 };
   int  ret;

   if(!PalInit(1)) FatalExit("PalInit failed", 1);
   CloseAppMgr();
   pAd = LoadAppDat(NULL);
   if(!pAd) FatalExit("Could not load APPMGR.DAT", 1);
   Count = GetAppCnt(pAd);

   InitDialog(&IcnDlg);
   LbSetCallBack(&IcnDlg, LBAPPS, AppCb);
   LbSetCount(&IcnDlg, LBAPPS, Count);
   Xpos = (640 - IcnDlg.Width) /2;
   Ypos = (200 - IcnDlg.Depth) /2;
   ShowDialog(&IcnDlg, Xpos, Ypos, "Select icon to save");
   PushKeys(HomeKey);
   do {
      int n;

      ret = HandleDialog(&IcnDlg, &Key);
      if(Key & 0xff) Key &= 0xff;
      n = GetFocus(&IcnDlg);
      if(n == LBAPPS) {
         int IconNbr;

         GetAppDef(pAd, LbGetPos(&IcnDlg, LBAPPS),
                  NULL, NULL, NULL, NULL, NULL, &IconNbr);
         pImg = GetAppIcn(pAd, IconNbr, ICN_200);
         SetDlgItem(&IcnDlg, BMICON, BMSI_PTR, pImg);
         if(Key == ENTER_KEY) ret = DN_OK;
      }
   } while(ret != DN_OK && ret != BNOK &&
           ret != DN_CANCEL && ret != BNCANCEL);
   CloseDialog(&IcnDlg);
   if((ret == DN_OK || ret == BNOK) && ValidIcon(pImg)) {
      SaveImg(pImg, "c:\\_dat\\saved.icn");
      MsgBox("IcnSaver", "|Saved your icon as | C:\\_DAT\\SAVED.ICN|",
             NULL, "  OK  ");
   }
   free(pAd);
   PalDeInit(1);
}

