'/* XCMT.BAS Extract comments from BASIC program files */
'/*          By: Dale Thorn                            */
'/*          Rev. 07.01.2000                           */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                    'clear the DOS screen
   locate 5, 1, 1                                   'locate cursor for messages
   print "    Usage:  XCMT  filename  [/R]"
   print
   print "    'filename' must be BASIC source code"
   print
   print "    If '/R' specified, remove all blank lines"
   close                                                  'close all open files
   system                                   'return control to operating system
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm > 0 then                            'user input an invalid DOS filename
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                       'display invalid-filename message [above] and exit
if iprm = 0 then                        'remove-blank-lines parameter specified
   if cprm(0) = "R" then                 'remove-blank-lines parameter is valid
      irem = not 0                          'set the remove-blank-lines flag ON
   else                                 'remove-blank-lines parameter NOT valid
      i = ifn.msgs("Invalid blank line removal parameter", 5, 24, 79, 1, 1)
   end if                   'display invalid-parameter message [above] and exit
else                                'remove-blank-lines parameter NOT specified
   irem = 0                                'set the remove-blank-lines flag OFF
end if
itab = 8                                 'set the number of spaces per hard tab

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if cext = "out" then                           'source file extension is '.OUT'
   cdst = cnam + ".tmp"                      'set temp-file extension to '.TMP'
else                                       'source file extension is NOT '.OUT'
   cdst = cnam + ".out"                      'set temp-file extension to '.OUT'
end if

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

close 1                                    'close the source file (binary mode)
open cfil for input as 1                    'open the BASIC program source file
open cdst for output as 2              'open the line-numbered destination file

init = -1                                'initialize the blank-line status flag
while not eof(1)                     'begin loop to process BASIC program lines
   line input #1, clin           'get a BASIC program line from the source file
   i = ifn.rtab(clin, itab)              'replace "hard" tabs with blank spaces
   ctmp = clin                                 'make a copy of the current line
   i = istr.rcmt(ctmp)                       'remove comments from current line
   if rtrim$(ctmp) = "" then                   'current line has NO actual code
      if ctmp <> clin then                      'current line is a comment line
         if init = 1 then     'blank line was processed w/prior comment line(s)
            print #2, ""     'prior comments processed; OK to output blank line
         end if
         print #2, rtrim$(clin)                'output the current comment line
         init = 0                               'set blank-line status flag OFF
      elseif init = 0 and irem = 0 then           'current line is a blank line
         init = 1                                'set blank-line status flag ON
      end if
   end if
wend

close                            'close all files prior to browsing output file
shell "brow " + cdst                   'browse the BASIC output (stripped) file
i = ifn.msgs("XCMT output file: " + cdst, 5, 24, 79, 0, 1)
close                                 'close all files in case not closed above
system                                      'return control to operating system
