'/* RCMT.BAS Remove comments from BASIC program files */
'/*          By: Dale Thorn                           */
'/*          Rev. 19.06.2003                          */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                    'clear the DOS screen
   locate 5, 1, 1                                   'locate cursor for messages
   print "    Usage:  RCMT  filename  [/R  /N]"
   print
   print "    'filename' must be BASIC source code"
   print
   print "    If '/R' specified, remove all blank lines"
   print "    If '/N' specified, don't display messages"
   close                                                  'close all open files
   system                                   'return control to operating system
end if

ipos1 = instr(ccmd, "/R")                    'remove all blank lines specified?
if ipos1 then                                 'user said remove all blank lines
   irem = not 0                             'set the remove-blank-lines flag ON
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))    'remove '/R'
else                                          'user said OK to display messages
   irem = 0                                'set the remove-blank-lines flag OFF
end if
ipos1 = instr(ccmd, "/N")               'don't display (except error) messages?
if ipos1 then                                 'user said don't display messages
   imsgdisp = 0                                'set message display flag to OFF
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))    'remove '/N'
else                                          'user said OK to display messages
   imsgdisp = not 0                             'set message display flag to ON
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then                           'user input an invalid DOS filename
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                       'display invalid-filename message [above] and exit
itab = 8                                 'set the number of spaces per hard tab

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if cext = ".out" then                          'source file extension is '.OUT'
   cdst = cnam + ".tmp"                      'set temp-file extension to '.TMP'
else                                       'source file extension is NOT '.OUT'
   cdst = cnam + ".out"                      'set temp-file extension to '.OUT'
end if

if imsgdisp then                              'user said OK to display messages
   i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)     'hide cursor and proceed
end if

close 1                                    'close the source file (binary mode)
open cfil for input as 1                    'open the BASIC program source file
open cdst for output as 2              'open the line-numbered destination file

init = -1                                'initialize the blank-line status flag
while not eof(1)                     'begin loop to process BASIC program lines
   line input #1, clin           'get a BASIC program line from the source file
   i = ifn.rtab(clin, itab)              'replace "hard" tabs with blank spaces
   ctmp = clin                                 'make a copy of the current line
   i = istr.rcmt(ctmp)                       'remove comments from current line
   if rtrim$(ctmp) <> "" then    'current line has an actual output line length
      if init = 1 then          'blank line was processed w/prior valid line(s)
         print #2, ""         'prior line(s) processed; OK to output blank line
      end if
      print #2, rtrim$(ctmp)                      'output the current text line
      init = 0                                  'set blank-line status flag OFF
   else                       'current line does NOT have an output line length
      ibeg = len(clin) - len(ltrim$(clin)) + 1  'first non-space char. position
      ipos = istr.lcsp(istr.lcsp(istr.lcsp(ibeg, clin, "'"), clin, "*"), clin, " ")
      cstr1 = ucase$(mid$(clin, ipos))        'get embedded macro text (if any)
      if left$(cstr1, 9) = "$INCLUDE:" _       'text is a BASIC 'include' macro
      or left$(cstr1, 8) = "OVERLAY:" _      'text is an RTLINK 'overlay' macro
      or left$(cstr1, 3) = "BC:" then             'text is BC compiler switches
         if init = 1 then       'blank line was processed w/prior valid line(s)
            print #2, ""      'prior line(s) processed; OK to output blank line
         end if
         print #2, rtrim$(clin)                   'output the current text line
         init = 0                               'set blank-line status flag OFF
      elseif init = 0 and irem = 0 and ctmp = clin then
         init = 1                                'set blank-line status flag ON
      end if
   end if
wend

close                            'close all files prior to browsing output file
if imsgdisp then                              'user said OK to display messages
   shell "brow " + cdst                'browse the BASIC output (stripped) file
   i = ifn.msgs("RCMT output file: " + cdst, 5, 24, 79, 0, 1)
end if
close                                 'close all files in case not closed above
system                                      'return control to operating system
