'/* DIFF.BAS  Compare two files/directories for differences */
'/*           By: Dale Thorn                                */
'/*           Rev. 19.06.1998                               */

'$include: 'basdef.h'
'$include: 'basio.h'
'$include: 'filecomp.h'
'$include: 'filekill.h'
'$include: 'getdir.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filecomp.bas'
'$include: 'filekill.bas'
'$include: 'getdir.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  DIFF  filespec1  filespec2  [/N(o report if not found)]", _
                5, 25, 80, 0, 1)
end if                              'display the usage message [above] and exit

if right$(ccmd, 2) = "/N" then           'user said NO report if file not found
   ccmd = left$(ccmd, len(ccmd) - 2)      'remove '/N' switch from command line
   istat = -1                            'set status for NO report if not found
else                                     'user said to report if file not found
   istat = 1                                'set status for report if not found
end if

ipos1 = instr(ccmd, " ")     'separator between source and destination filespec
if ipos1 = 0 then          'separator NOT found (source or dest. not specified)
   i = ifn.msgs("Source or compare file(s) not specified", 5, 25, 80, 1, 1)
end if                              'display the error message [above] and exit
csrcprm = rtrim$(left$(ccmd, ipos1 - 1))           'source files for comparison
cdstprm = ltrim$(mid$(ccmd, ipos1 + 1))       'destination files for comparison

i = ifn.msgs("Please standby", 5, 25, 80, 0, 0)   'wait while loading filespecs

csrcdir = "dsrc.dir"                        'initialize source filespec dirname
i = ifn.gdir(csrcdir, csrcfil, csrcfsp, csrchdr, csrcprm, isrcfl1, lsrcsiz, 0)
if csrcfil = "" then                               'source files were NOT found
   i = ifn.kill(isrcfl1, csrcdir)                'kill source filespec filename
   i = ifn.msgs("Source file(s) not found", 5, 25, 80, 1, 1)
end if                              'display the error message [above] and exit

cdstdir = "ddst.dir"                   'initialize destination filespec dirname
i = ifn.gdir(cdstdir, cdstfil, cdstfsp, cdsthdr, cdstprm, idstfl1, ldstsiz, 0)
if cdstfil = "" then                          'destination files were NOT found
   i = ifn.kill(idstfl1, cdstdir)           'kill destination filespec filename
   i = ifn.msgs("Dest. [compare] file(s) not found", 5, 25, 80, 1, 1)
end if                              'display the error message [above] and exit

csavsrcfil = csrcfil              'save first source file in case of swap below
lsavsrcsiz = lsrcsiz          'save first source filesize in case of swap below
i = ifn.gdir(csrcdir, csrcfil, csrcfsp, csrchdr, csrcprm, isrcfl1, lsrcsiz, 0)

csavdstfil = cdstfil         'save first destination file in case of swap below
lsavdstsiz = ldstsiz     'save first destination filesize in case of swap below
i = ifn.gdir(cdstdir, cdstfil, cdstfsp, cdsthdr, cdstprm, idstfl1, ldstsiz, 0)

if csrcfil <> "" and cdstfil = "" then '1 dest. file only; comp.dest.-to-source
   swap csrcdir, cdstdir             'swap source/destination filespec dirnames
   swap csrcfil, cdstfil                     'swap source/destination filenames
   swap csrcfsp, cdstfsp                     'swap source/destination filespecs
   swap csrchdr, cdsthdr                  'swap source/destination dir. headers
   swap csrcprm, cdstprm           'swap source/destination filespec parameters
   swap isrcfl1, idstfl1                  'swap source/destination file handles
   swap lsrcsiz, ldstsiz                     'swap source/destination filesizes
   swap csavsrcfil, csavdstfil         'swap saved source/destination filenames
   swap lsavsrcsiz, lsavdstsiz         'swap saved source/destination filesizes
end if

if csrcfil <> "" or cdstfil <> "" then     'source or dest. spec. is multi-file
   ifilcnt = 2             'set count to indicate 2 or more compare files found
else                            'source and destination specs. are single files
   ifilcnt = 1                 'set count to indicate only 1 compare file found
end if

locate 6, 1, 1          'set cursor so comp.list begins below 'standby' message
if io.ktst(0) <> KEY.ESC then   'user didn't ESCape during file initializations
   if ifilcnt > 1 then                'multiple file comparisons were indicated
      csavdstfil = csavsrcfil       'set destination filename = source filename
   end if                               'compare previous (saved) files [below]
   i = ifn.fcmp(csrchdr + csavsrcfil, cdsthdr + csavdstfil, itstkey, (istat), 0)
   while itstkey <> KEY.ESC and csrcfil <> ""   'subsequent files are available
      if ifilcnt > 1 then             'multiple file comparisons were indicated
         cdstfil = csrcfil          'set destination filename = source filename
      end if                  'compare current source/destination files [below]
      i = ifn.fcmp(csrchdr + csrcfil, cdsthdr + cdstfil, itstkey, (istat), 0)
      i = ifn.gdir(csrcdir, csrcfil, csrcfsp, csrchdr, csrcprm, isrcfl1, lsrcsiz, 0)
   wend                  'get next available source file for comparison [above]
end if

i = ifn.kill(isrcfl1, csrcdir)                'kill the source filespec dirname
i = ifn.kill(idstfl1, cdstdir)           'kill the destination filespec dirname

close                                 'close all files in case not closed above
system                                              'return to operating system

function io.kbuf(inop)            '/* get key value (don't strip key buffer) */
   do                                                         '/* begin loop */
      key$ = inkey$                              '/* get key from key buffer */
   loop while len(key$) = 0                      '/* loop until a key is hit */
   if asc(key$) then                             '/* key value in first byte */
      io.kbuf = asc(key$)            '/* return key value to calling program */
   else                                      '/* zero value ("extended" key) */
      io.kbuf = asc(mid$(key$, 2)) + 128      '/* add 128 to 2nd byte of key */
   end if
end function                                   '/* return to calling program */

function io.kget(inop)                 '/* strip key buffer and wait for key */
   do                    '/* begin loop to get User key (shell or non-shell) */
   loop while len(inkey$)           '/* loop while key buffer contains a key */
   io.kget = io.kbuf(0)              '/* return key value to calling program */
end function                                   '/* return to calling program */

function io.ktst(inop)                         '/* return last key (no wait) */
   key$ = inkey$                                 '/* get key from key buffer */
   if len(key$) then                           '/* key buffer contains a key */
      if asc(key$) then                          '/* key value in first byte */
         inop = asc(key$)                            '/* key value to return */
      else                                   '/* zero value ("extended" key) */
         inop = asc(mid$(key$, 2)) + 128      '/* add 128 to 2nd byte of key */
      end if
   else                                '/* key buffer does NOT contain a key */
      inop = 0                              '/* set return key value to zero */
   end if
   io.ktst = inop                    '/* return key value to calling program */
end function                                   '/* return to calling program */
