#include "ntui.h"
#include <assert.h>

static const char *queryText;
static ACTION      queryAct;

static BOOL CALLBACK queryDlgProc(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  BOOL ret = FALSE;
  switch (uMsg)
  {
    case WM_INITDIALOG:
      statDlgPlaceSubDlg(hWnd);
      SetWindowText(GetDlgItem(hWnd, IDC_QUERY), queryText);
      ret = TRUE;
      break;
    case WM_COMMAND:
      if (HIWORD(wp) == BN_CLICKED)
      {
        int id = GetDlgCtrlID((HWND) lp);
        switch (id)
        {
          case IDC_YESTOALL:
            {
              UINT32 force;
              switch (queryAct)
              {
                case ACTION_ADD:     force = OPT_FORCE_ADD; break;
                case ACTION_COPY:
                case ACTION_UPDATE:  force = OPT_FORCE_COPY; break;
                case ACTION_DELETE:  force = OPT_FORCE_DELETE; break;
                default:
                  force = 0;
                  assert(0);
              }
              optionSet(0, force);
            }
          case IDC_YES:
            EndDialog(hWnd, TRUE);
            break;
          case IDC_NOTOALL:
            {
              UINT32 never;
              switch (queryAct)
              {
                case ACTION_ADD:     never = OPT_NEVER_ADD; break;
                case ACTION_COPY:
                case ACTION_UPDATE:  never = OPT_NEVER_COPY; break;
                case ACTION_DELETE:  never = OPT_NEVER_DELETE; break;
                default:
                  never = 0;
                  assert(0);
              }
              optionSet(0, never);
            }
          case IDC_NO:
            EndDialog(hWnd, FALSE);
            break;
          default:
            assert(0);
        }
      }
      break;
  }
  return ret;
}

BOOL queryDlgExec(const char *txt, ACTION action)
{
  queryText = txt;
  queryAct  = action;
  return DialogBox(0, MAKEINTRESOURCE(IDD_QUERY), 0, queryDlgProc);
}
