/****************************************************************/
/*			MAPPOTpW擾vO						*/
/*									mptaid.exm					*/
/*													By Brahma	*/
/*																*/
/*					1995/08/01	{쐬					*/
/*					1995/08/04	{@\					*/
/*					1996/01/08	J[\F@\			*/
/*								C							*/
/****************************************************************/

#include "lxapi.h"
#include <dos.h>
#include "mptaid.h"

char far *msgF1		 = "PCX File Open";
char far *msgF2		 = "";
char far *msgF3		 = "";
char far *msgF4		 = "";
char far *msgF5		 = "";
char far *msgF6		 = "";
char far *msgF7		 = "";
char far *msgE6		 = "OK";
char far *msgE7		 = "Cancel";

char far **StringTable[] = {
	&msgF1,
	&msgE6,
	&msgE7,
};

char	c_FileName[81] = "";
char	c_DirName[81] = "";
char	c_DefaultName[16] = "*.PCX";
char	*p_FileList[LISTCOUNT];
char	c_FileList[LISTCOUNT*13];
char	*p_DirList[DIRCOUNT];
char	c_DirList[DIRCOUNT*13];

LHFKEY OkCancelFKeys[] = {
	{ (PLHRES)&msgE6, NULL, 9, FKEY_SENDMSG },
	{ (PLHRES)&msgE7, NULL, 10+FKEY_LAST, FKEY_SENDMSG }
};

LHWINDOW FoArray[] = {
	{PathText, 38, 49, 30, 1,
	(PLHRES)&msgF2, (PLHDATA)c_FileName, 80, STYLE_WHCHAR,
	NULL, PARENT_FKEYS, (PLHMENU)c_DefaultName, NO_HELP},
	{StaticText, 38, 65, 171, 2,
	(PLHRES)&msgF3, (PLHDATA)c_DirName,
	80, STYLE_NOBORDER|STYLE_WHCHAR,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
	{FileListBox, 38, 81, 15, 6,
	(PLHRES)&msgF4, (PLHDATA)p_FileList, LISTCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
	NULL, PARENT_FKEYS, (PLHMENU)LISTCOUNT, NO_HELP},
	{DirListBox, 266, 81, 15, 6,
	(PLHRES)&msgF5, (PLHDATA)p_DirList, DIRCOUNT, STYLE_WHCHAR|STYLE_NOTIFY,
	NULL, PARENT_FKEYS, (PLHMENU)DIRCOUNT, NO_HELP},
	{PushButton, 458, 51, 80, 20,
	(PLHRES)&msgF6, (PLHDATA)CMD_DONE, 13, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP, STATUS_DEF_PUSHB},
	{PushButton, 458, 88, 80, 20,
	(PLHRES)&msgF7, (PLHDATA)CMD_ESC, 0, PUSHB_SENDMSG|STYLE_PUSHBUTTON,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW FileOpenDialog = {
	(PLHCLASS)FileOpenDialogBoxT, 50, 50, 60, 10,
	(PLHRES)&msgF1, (PLHDATA)FoArray, countof(FoArray), 0,
	NULL, OkCancelFKeys, NO_MENU, NO_HELP
};

LHWINDOW PCXDialog = {
	(PLHCLASS)PCXDialogBox, 0, 0, 640, 200,
	NULL, 0, 0, 0,
	NULL, NO_FKEYS, NO_MENU, NO_HELP
};

BOOL			Done;
EVENT			app_event;
unsigned char	rbuf[RBUFSIZ];
unsigned char	cb_buf[CBUFSIZ];
unsigned char	dis_buf[88];
unsigned char	Back_X[88];
unsigned char	Back_Y[208];
int				cur_X;
int				cur_Y;
BOOL			dispinit = TRUE;
int				disp_x;
int				disp_y;
BOOL			CurBlack = TRUE;

int far FileOpenDialogBoxT( PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra )
{
	int	i;

	switch( Message ) {
		case CREATE:
			for( i = 0; i < LISTCOUNT; i++ )
				p_FileList[i] = c_FileList + i * 13;
			for( i = 0; i < DIRCOUNT; i++ )
				p_DirList[i] = c_DirList + i * 13;
			break;
		case COMMAND:
			switch( Data ) {
				case CMD_DONE:
					SubclassMsg(FileOpenDialogBox, Wnd, DESTROY, DESTROY_NODRAW, 0 );
					SendMsg( &PCXDialog, CREATE, CREATE_FOCUS, 0 );
					return TRUE;
				case CMD_ESC:
					Done = TRUE;
					return TRUE;
			 }
	 }
	return SubclassMsg((PLHCLASS)FileOpenDialogBoxB, Wnd, Message, Data, Extra);
}

int far PCXDialogBox( PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra )
{
	int	i;

	switch( Message ) {
		case DRAW:
			if( Data & DRAW_FRAME ) {
				ClearRect( Wnd->x, Wnd->y, Wnd->w, Wnd->h );
				if( !DispPcx()) {
					Done = TRUE;
					return TRUE;
				 }
				DispHline();
			}
			if( Data & DRAW_FKEYS )
				return TRUE;
			break;
		case KEYSTROKE:
			RestoreScreen();
			switch( Data ) {
				case DOWNKEY:
					if( cur_Y < ( disp_y - 1 ))
						cur_Y++;
					break;
				case TWOKEY:
					if( cur_Y < ( disp_y - 10 ))
						cur_Y += 10;
					else
						cur_Y = disp_y - 1;
					break;
				case UPKEY:
					if( cur_Y > 0 )
						cur_Y--;
					break;
				case EIGHTKEY:
					if( cur_Y > 9 )
						cur_Y -= 10;
					else
						cur_Y = 0;
					break;
				case LEFTKEY:
					if( cur_X > 0 )
						cur_X--;
					break;
				case FOURKEY:
					if( cur_X > 9 )
						cur_X -= 10;
					else
						cur_X = 0;
					break;
				case RIGHTKEY:
					if( cur_X < ( disp_x - 1 ))
						cur_X++;
					break;
				case SIXKEY:
					if( cur_X < ( disp_x - 10 ))
						cur_X += 10;
					else
						cur_X = disp_x - 1;
					break;
				case ONEKEY:
					if( cur_X > 9 )
						cur_X -= 10;
					else
						cur_X = 0;
					if( cur_Y < ( disp_y - 10 ))
						cur_Y += 10;
					else
						cur_Y = disp_y - 1;
					break;
				case THREEKEY:
					if( cur_X < ( disp_x - 10 ))
						cur_X += 10;
					else
						cur_X = disp_x - 1;
					if( cur_Y < ( disp_y - 10 ))
						cur_Y += 10;
					else
						cur_Y = disp_y - 1;
					break;
				case SEVENKEY:
					if( cur_X > 9 )
						cur_X -= 10;
					else
						cur_X = 0;
					if( cur_Y > 9 )
						cur_Y -= 10;
					else
						cur_Y = 0;
					break;
				case NINEKEY:
					if( cur_X < ( disp_x - 10 ))
						cur_X += 10;
					else
						cur_X = disp_x - 1;
					if( cur_Y > 9 )
						cur_Y -= 10;
					else
						cur_Y = 0;
					break;
				case FIVEKEY:
					cur_X = disp_x / 2;
					cur_Y = disp_y / 2;
					break;
				case ESCKEY:
					Done = TRUE;
					break;
				case ENTERKEY:
					m_lock();
					if( !m_open_cb()) {
						m_reset_cb( "MPTAID" );
						m_new_rep( "TEXT" );
						sprintf( cb_buf, "MPT:%s,%3.3d%3.3d", c_FileName, cur_X, cur_Y );
						m_cb_write( cb_buf, strlen( cb_buf ));
						m_fini_rep();
						m_close_cb();
					 }
					m_unlock();
					if( !( m_sh_status() & 0x07 ))
						Done = TRUE;
					break;
				case SPACEKEY:
					if( CurBlack )
						CurBlack = FALSE;
					else
						CurBlack = TRUE;
					break;
				default:
					break;
			 }
			DispHline();
			return TRUE;
	 }
	return SubclassMsg( Object, Wnd, Message, Data, Extra );
}

int far FileOpenDialogBoxB( PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra )
{
	int	i;

	for( i = 0; i <= 5; i++ ) {
		if( &((PLHWINDOW)Wnd->Data)[i] == GetFocus())
			break;
	 }

	if( Message == KEYSTROKE ) {
		switch( Data ){
		case UPKEY:
			switch( i ) {
			case	0:
				SendMsg( &((PLHWINDOW)Wnd->Data)[5], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	4:
				SendMsg( &((PLHWINDOW)Wnd->Data)[2], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	5:
				SendMsg( &((PLHWINDOW)Wnd->Data)[4], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			 }
			break;
		case DOWNKEY:
			switch( i ) {
			case	0:
				SendMsg( &((PLHWINDOW)Wnd->Data)[2], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	4:
				SendMsg( &((PLHWINDOW)Wnd->Data)[5], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	5:
				SendMsg( &((PLHWINDOW)Wnd->Data)[0], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			 }
			break;
		case LEFTKEY:
			switch( i ) {
			case	2:
				SendMsg( &((PLHWINDOW)Wnd->Data)[0], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	3:
				SendMsg( &((PLHWINDOW)Wnd->Data)[2], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	4:
				SendMsg( &((PLHWINDOW)Wnd->Data)[0], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	5:
				SendMsg( &((PLHWINDOW)Wnd->Data)[3], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			 }
			break;
		case RIGHTKEY:
			switch( i ) {
			case	2:
				SendMsg( &((PLHWINDOW)Wnd->Data)[3], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			case	3:
				SendMsg( &((PLHWINDOW)Wnd->Data)[5], SETFOCUS, SETFOCUS_NORMAL, 0 );
				return TRUE;
			 }
			break;
		 }
	}

	return SubclassMsg(FileOpenDialogBox, Wnd, Message, Data, Extra);
}

void FixupFarPtrs( void )
{
	int i;

	for ( i = 0; i < countof( StringTable ); i++ )
		*((( int *)( StringTable[i] )) + 1 ) = _DS;
}

void l_fini( void )
{
	FixupFarPtrs();
	app_event.norm.do_event = DO_FINI;
	m_action( &app_event );
}

BOOL GetDefDir( void )
{
	FILE	fd;
	int		lenp;

	m_lock();
	if( m_open( &fd, ENV_FN1, ENV_LE1, 0, 0 )) {
		if( !m_open( &fd, ENV_FN2, ENV_LE2, 0, 0 )) {
			if( m_read( &fd, rbuf, 81, &lenp ) != 0 ) {
				m_close( &fd );
				m_unlock();
				return FALSE;
			 }
		 }
	 } else {
		if( m_read( &fd, rbuf, 81, &lenp ) != 0 ) {
			m_close( &fd );
			m_unlock();
			return FALSE;
		 }
	 }
	m_close( &fd );
	m_unlock();

	for( lenp = 0; lenp < 81; lenp++ ) {
		if( rbuf[lenp] == 0x0d ) {
			c_DirName[lenp] = '\0';
			break;
		 } else
			c_DirName[lenp] = rbuf[lenp];
	 }
	c_DirName[80] = '\0';

	return TRUE;
}

/*
BOOL GetCbdDat( void )
{
	int	index, len;

	m_lock();
	if( m_open_cb() != 0 ) {
		m_unlock();
		return	FALSE;
	 }
	if( m_rep_index((char far *)"TEXT", (int far *)&index, (unsigned *)&len) != 0 ) {
		m_close_cb();
		m_unlock();
		return	TRUE;
	 }
	if( len > CBUFSIZ ) {
		m_cb_read( index, 0, cb_buf, CBUFSIZ );
		len = CBUFSIZ;
	 } else
		m_cb_read( index, 0, cb_buf, len );
	m_close_cb();
	m_unlock();

	if(( cb_buf[0] == 'M' && cb_buf[1] == 'P' && cb_buf[2] == 'T' ) ||
	   ( cb_buf[0] == 'P' && cb_buf[1] == 'C' && cb_buf[2] == 'X' ) ||
	   ( cb_buf[0] == 'M' && cb_buf[1] == 'A' && cb_buf[2] == 'P' )) {
// \
	 }

	return TRUE;
}
*/

BOOL DispPcx( void )
{
	FILE	fd;
	int		lenp, byte_len, rcnt, cnt, chr, ocnt, i, x, y;
	BOOL	pharf;
	unsigned char	*t_buf;

	strcpy( rbuf, c_DirName );
	if( strlen( rbuf ) > 3)
		strcat( rbuf, "\\" );
	strcat( rbuf, c_FileName );
	if( strchr( rbuf, '.' ) == NULL )
		strcat( rbuf, ".PCX" );

	m_lock();
	if( m_open( &fd, rbuf, strlen( rbuf ), 0, 0 )) {
		m_unlock();
		return FALSE;
	 }
	if( m_read( &fd, rbuf, 128, &lenp ) ||
		rbuf[0] != 0x0a || rbuf[2] != 0x01 || rbuf[3] != 0x01 ) {
		m_close( &fd );
		m_unlock();
		return FALSE;
	 }

	byte_len = ( rbuf[67] << 8 ) + rbuf[66];
	disp_x = (( rbuf[9] - rbuf[5] ) << 8 ) + ( rbuf[8] - rbuf[4] ) + 1;
	if( disp_x > 640 )
		disp_x = 640;
	disp_y = (( rbuf[11] - rbuf[7] ) << 8 ) + ( rbuf[10] - rbuf[6] ) + 1;
	if( disp_y > 200 )
		disp_y = 200;

	if( dispinit ) {
		dispinit = FALSE;
		cur_X = disp_x / 2;
		cur_Y = disp_y / 2;
	 }

	*dis_buf = 0x01;
	*( dis_buf + 1 ) = 0x00;
	*( dis_buf + 2 ) = 0x01;
	*( dis_buf + 3 ) = 0x00;
	*( dis_buf + 4 ) = disp_x % 0x0100;
	*( dis_buf + 5 ) = disp_x >> 8;
	*( dis_buf + 6 ) = 0x01;
	*( dis_buf + 7 ) = 0x00;
	t_buf = dis_buf + 8;
	x = y = ocnt = 0;
	pharf = FALSE;
	while( !m_read( &fd, rbuf, RBUFSIZ, &lenp )) {
		if( !lenp )
			break;
		rcnt = 0;
		while( rcnt < lenp ) {
			cnt = 1;
			if( pharf ) {
				cnt = ocnt;
				pharf = FALSE;
				chr = *( rbuf + rcnt++ );
			 } else if( 0xc0 == ( 0xc0 & *( rbuf + rcnt ))) {
				cnt = 0x3f & *( rbuf + rcnt++ );
				if( rcnt == lenp ) {
					ocnt = cnt;
					pharf = TRUE;
					break;
				 }
				chr = *( rbuf + rcnt++ );
			 } else
				chr = *( rbuf + rcnt++ );
			for( i = 0; i < cnt; i ++  ) {
				if(( x * 8 ) < 640)
					*( t_buf++ ) = chr;
				x++;
				if( x >= byte_len ) {
					put_image( 0, y, dis_buf );
					t_buf = dis_buf + 8;
					x = 0;
					if( y++ >= 199 ) {
						m_close( &fd );
						m_unlock();
						return TRUE;
					 }
				 }
			 }
		 }
		if( lenp < RBUFSIZ )
			break;
	 }
	m_close( &fd );
	m_unlock();

	return TRUE;
}

void DispHline( void )
{
	int	color;

	if( CurBlack )
		color = 1;
	else
		color = 0;

	get_image( 0, cur_Y, 640, 1, Back_X );
	get_image( cur_X - cur_X % 8, 0, 8, 200, Back_Y );
	Line( 0, cur_Y, 639, cur_Y, color );
	Line( cur_X, 0, cur_X, 199, color );
}

void RestoreScreen( void )
{
	put_image( 0, cur_Y, Back_X );
	put_image( cur_X - cur_X % 8, 0, Back_Y );
}

void put_image( int c_x, int c_y, unsigned char *c_buf )
{

	struct REGPACK	pregs;

	pregs.r_ax = 0x0e00;
	pregs.r_cx = c_x;
	pregs.r_dx = c_y;
	pregs.r_es = _DS;
	pregs.r_di = ( unsigned int )c_buf;
	intr( 0x5f, &pregs );

}

void get_image( int c_x, int c_y, int w_x, int w_y, unsigned char *c_buf )
{

	struct REGPACK	pregs;

	pregs.r_ax = 0x0d00;
	pregs.r_cx = c_x;
	pregs.r_dx = c_y;
	pregs.r_si = c_x + w_x - 1;
	pregs.r_bp = c_y + w_y - 1;
	pregs.r_es = _DS;
	pregs.r_di = ( unsigned int )c_buf;
	intr(0x5f, &pregs);

}

void main( void )
{
	LHAPIBLOCK LHAPIData;

	m_init_app( SYSTEM_MANAGER_VERSION );
	InitializeLHAPI( &LHAPIData );

	SetDefaultFont(FONT_NORMAL);

//	if( !GetCbdDat() || !GetDefDir())
	if( !GetDefDir())
		l_fini();

	SendMsg( &FileOpenDialog, CREATE, CREATE_FOCUS, 0 );

	Done = FALSE;
	while( !Done ) {
		app_event.norm.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.norm.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				FixupFarPtrs();
				ReactivateLHAPI( &LHAPIData );
				break;
			case E_DEACT:
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				Done = TRUE;
				break;
			case E_KEY:
         		SendFocusMsg( KEYSTROKE, app_event.norm.data, app_event.norm.scan);
				break;
		 }
	 }

	l_fini();

}
