/*
 * This program encode the Hirakana part of the Japanese double byte character
 * set by the encoding method used by Japanese pagers 
 *
 */

#include	"lxapi.h"
#include	<ctype.h>
#include	<string.h>
#include	<stdlib.h>

char near	EditString[22];
char near	ResultString[22];

char far	*msgnull =		"";
char far	*msgAppName =	"ApptBook";
char far	*msgTitle =		"Pager Encoder";
char far	*msgQuit =		"&Quit";
char far	*msgOk =		"OK";
char far	*msgResult = ResultString;
char far	**StringTable[]={
				&msgnull,&msgTitle,
				&msgAppName,&msgQuit,&msgOk,&msgResult,
};

/* Following table is the Hirakana part of the Japanese double byte 
 * character set. (If your sysem does not support double byte character
 * set, you will probably see garbaged characters) 
 */

char		*strtbl[110]={
	"","","","[","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","","",
	"","","","","","","","","",""};

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far MainDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);
int far EditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...);

void far DoQuit( void );

BOOL		Done;
LHAPIBLOCK	CapData;
EVENT_NORM		app_event;

LHFKEY MainFKeys[] = {
	{(PLHRES)&msgOk,(PLHFUNC)CMD_ESC,10+FKEY_LAST,FKEY_SENDMSG }
};

LHMENU MainMenu[] = {
	{(PLHRES)&msgQuit,(PLHFUNC)DoQuit, 0 },
	{ 0, 0, 0, 0 }
};

LHWINDOW TDateTime = {
		DateTime,0,0,0,0,
		0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
		NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
		TitleBar,0,0,0,0,
		(PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
		NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};

LHWINDOW MainArray[] = {
		{StaticText,160,20,20,1,
		(PLHRES)&msgTitle,NULL,1,STYLE_NOBORDER|STYLE_WHCHAR,
		NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP},
		{(PLHCLASS)EditHandler,160,80,19,1,
		(PLHRES)&msgnull,EditString,19,STYLE_WHCHAR,
		NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP},
		{StaticText,160,140,22,1,
		(PLHRES)&msgResult,NULL,0,STYLE_NOBORDER|STYLE_WHCHAR,
		NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP},
};

LHWINDOW MainDlg = {
		(PLHCLASS)MainDlgHandler, 0, 10, 640, 178,
		(PLHRES)&msgnull,(PLHDATA)MainArray,countof(MainArray),0,NULL,
		MainFKeys, MainMenu, NO_HELP };

LHWINDOW MainView = {
		(PLHCLASS)MainHandler, 0, 0, 640, 190,
		(PLHRES)&msgnull,NULL,0,0,NULL,
		MainFKeys, MainMenu, NO_HELP };

#if defined(TURBOC)
#define GetDataSeg()	_DS
#define GetCodeSeg()	_CS
#define GetStack()	_SP
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#define GetCodeSeg()	_asm_(" mov ax,cs\n")
#define GetStack()	_asm_(" mov ax,sp\n")
#endif

void FixupFarPtrs( void )
{
	int i, dataseg;

#if defined(MSC)
	_asm {
		mov ax,ds
		mov dataseg,ax
	 }
#else
	dataseg=GetDataSeg();
#endif

	for ( i = 0; i < countof( StringTable ); i++ )
		*((( int *)( StringTable[i] )) + 1 ) = dataseg;
}

void ConvString(void) {
int	i,j,k;
char lastch,mojibuf[3];		/* moji = character in Japanese*/

	mojibuf[2]='\0';lastch=11;
	ResultString[0]='\0';
	j=strlen(EditString);
	if(isdigit(EditString[0]))
	{
		for(i=0;i<j;i+=2)
		{
			mojibuf[0]=EditString[i];mojibuf[1]=EditString[i+1];
			strcpy(&ResultString[i],strtbl[atoi(mojibuf)]);
		}
	}
	else
	{
		for(i=0;i<j;i+=2)
		{
			mojibuf[0]=EditString[i];mojibuf[1]=EditString[i+1];
			for(k=0;k<110;k++)
				if(strcmp(mojibuf,strtbl[k])==0) break;
			if(k==50) k=60;
			if(k==100) k=43;
			if(k==109) k=1;
			if(k==106) k=81;
			if(k==107) k=83;
			if(k==108) k=85;
			if(k>55&&k<60) k+=10;
			if(k>100&&k<106) k-=90;
			if(k==3) k=((lastch-1)%5)+11;
			if(k==110) strcpy(&ResultString[i],"??");
			else
			{ResultString[i]=(k/10)+0x30;ResultString[i+1]=(k%10)+0x30;
				ResultString[i+2]='\0';}
			lastch=k;
		}
	}
}

int far EditHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
/*			SendMsg(Window,DRAW,DRAW_ALL,0);*/
			switch( Data ) {
		 		case 0x0d:
		 		case F10KEY:
					ConvString();
					SendMsg(MainArray+2,DRAW,DRAW_ALL,0);
					return TRUE;
			}
			break;
	}
	return SubclassMsg(Edit, Window, Message, Data, Extra);
}

int far MainDlgHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case DRAW:
			SendMsg((PLHWINDOW)Window->Data, Message, Data, Extra);
			return TRUE;
		case KEYSTROKE:
			if(Data!=MENUKEY) return TRUE;
	}
	return SubclassMsg(DialogBox, Window, Message, Data, Extra);
}

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
	switch (Message) {
		case KEYSTROKE:
			break;
		case DRAW:
			if (Data&DRAW_FRAME)
				ClearRect(Window->x,Window->y,Window->w,Window->h);
			break;
	}
	return SubclassMsg(Object, Window, Message, Data, Extra);
}

void far DoQuit( void )
{
	Done = TRUE;
}

void main( void )
{
	m_init_app( SYSTEM_MANAGER_VERSION );

	InitializeLHAPI( &CapData );

	EditString[0]=ResultString[0]=0;

	SetDefaultFont(FONT_LARGE);
	SetMenuFont(FONT_NORMAL);

	m_reg_app_name( msgAppName );

	SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
	SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );

	SendMsg( &MainDlg, CREATE, CREATE_FOCUS,0 );
	Done = FALSE;

	while( !Done ) {
		app_event.do_event = DO_EVENT;
		m_action( &app_event );
		switch( app_event.kind ) {
			case E_ACTIV:
			case E_REFRESH:
				FixupFarPtrs();
				ReactivateLHAPI( &CapData );
/*				SetIme();*/
				break;
			case E_DEACT:
				DeactivateLHAPI();
				break;
			case E_TERM:
			case E_BREAK:
				FixupFarPtrs();
				Done = TRUE;
				break;
			case E_NONE:
				SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
				break;
			case E_KEY:
				SendMsg(GetFocus(), KEYSTROKE, app_event.data,app_event.scan);
				break;
		}
	}
	m_fini();
}
