unit SetForm;

{
 ***** version 1.0 ***** 
 (c) Pavel Zampach (zampach@volny.cz), 2005
 GNU GENERAL PUBLIC LICENSE 
 Source code for Borland Delphi Compiler (originally ver. 7.0)
}

interface


procedure LaunchSetForm (const ParentWindow : thandle; const IniFileName : string);

{ ****************************************************************** }

implementation

{
  This unit uses Key Objects Library
  KOL is provided free with the source code.
  Copyright (C) Vladimir Kladov, 2000-2003.
  Web-Page: http://bonanzas.rinet.ru
}

uses
  Windows, KOL;

var
  Form1,
  Combo1, Combo2,
  Panel1,
  ChBA, ChBC, ChBD, ChBE, ChBF, ChBG,
  Button1, Button2 : pControl;

{ ------------------------------------------------------------------ }

procedure on_butOK_Click;
begin
  Form1.ModalResult := 1; // O.K.
end;
  
{ ------------------------------------------------------------------ }

procedure on_butCl_Click;
begin
  Form1.ModalResult := 2; // Cancel
end;
  
{ ------------------------------------------------------------------ }

procedure LaunchSetForm (const ParentWindow : thandle; const IniFileName : string);

var
  Ini    : pIniFile;
  DrvStr : string;

begin
  Applet := NewApplet ('');                                // create container object
  SetParent (Applet.GetWindowHandle, ParentWindow);        // set parent window, effect???
  AppletRunning := true;                                   // switch on message loop

  Form1 := NewForm (Applet, 'HPLX plugin settings');       // create main form
  Form1.Font.FontName := 'MS Sans Serif';                  // and its properties
  Form1.Font.FontHeight := -11;
  Form1.SetSize (280, 190);
  Form1.CanResize := false;
  Form1.CenterOnParent;
  Form1.Style := Form1.Style and not (WS_MINIMIZEBOX or WS_MAXIMIZEBOX);
  Form1.Tabulate;
  
  Ini := OpenIniFile (IniFileName);
  Ini.Section := 'HPLX';
  Ini.Mode := ifmRead;
  
  NewLabel (Form1, 'Serial port:').SetPosition ( 10, 5);
  NewLabel (Form1, 'Baudrate:'   ).SetPosition (160, 5);

  Combo1 := NewComboBox (Form1, [coReadOnly]).SetPosition (10, 25);
  Combo1.Color := clWhite;
  with Combo1^ do begin
    Add ('COM1');
    Add ('COM2');
    Add ('COM3');
    Add ('COM4');
    Add ('COM5');
    Add ('COM6');
    Add ('COM7');
    Add ('COM8');
  end;
  Combo1.SelStart := Combo1.IndexOf (Ini.ValueString ('Port', 'COM1'));

  Combo2 := NewComboBox (Form1, [coReadOnly]).SetPosition (160, 25);
  Combo2.Color := clWhite;
  with Combo2^ do begin
    Add (  '1200');
    Add (  '2400');
    Add (  '4800');
    Add (  '9600');
    Add ( '19200');
    Add ( '38400');
    Add ( '57600');
    Add ('115200');
  end;
  Combo2.SelStart := Combo2.IndexOf (Ini.ValueString ('Speed', '115200'));

  DrvStr := Ini.ValueString ('Drives', 'ACD');
  Ini.Free;  
  
  Panel1 := NewPanel (Form1, esLowered).SetPosition (10, 60);
  Panel1.SetSize (250, 62);

    NewLabel (Panel1, 'HPLX drives:').SetPosition (5, 2);

    ChBA := NewCheckBox (Panel1, 'A:').SetPosition (  5, 18);
    ChBA.Checked := (Pos ('A', DrvStr) <> 0);

    ChBC := NewCheckBox (Panel1, 'C:').SetPosition (  5, 38);
    ChBC.Checked := (Pos ('C', DrvStr) <> 0);

    ChBD := NewCheckBox (Panel1, 'D:').SetPosition (110, 18);
    ChBD.Checked := (Pos ('D', DrvStr) <> 0);

    ChBE := NewCheckBox (Panel1, 'E:').SetPosition (110, 38);
    ChBE.Checked := (Pos ('E', DrvStr) <> 0);

    ChBF := NewCheckBox (Panel1, 'F:').SetPosition (215, 18);
    ChBF.Checked := (Pos ('F', DrvStr) <> 0);

    ChBG := NewCheckBox (Panel1, 'G:').SetPosition (215, 38);
    ChBG.Checked := (Pos ('G', DrvStr) <> 0);
  
  Button1 := NewButton (Form1, 'OK').SetPosition (30, 135);
  Button1.OnClick := TOnEvent (MakeMethod (nil, @on_butOK_Click));
  Button1.DefaultBtn := true;
//  Button1.Focused := true;
  
  Button2 := NewButton (Form1, 'Cancel').SetPosition (175, 135);
  Button2.OnClick := TOnEvent (MakeMethod (nil, @on_butCl_Click));
  Button2.CancelBtn := true;

  Form1.ShowModalEx;                                       // show form window
  
  if Form1.ModalResult = 1 then begin                      // Button1 (OK) was pressed
    Ini := OpenIniFile (IniFileName);
    Ini.Section := 'HPLX';
    Ini.Mode := ifmWrite;
    Ini.ValueString ('Port',  Combo1.Items[Combo1.CurIndex]);
    Ini.ValueString ('Speed', Combo2.Items[Combo2.CurIndex]);
    DrvStr := '';
    if ChBA.Checked then DrvStr := DrvStr + 'A';
    if ChBC.Checked then DrvStr := DrvStr + 'C';
    if ChBD.Checked then DrvStr := DrvStr + 'D';
    if ChBE.Checked then DrvStr := DrvStr + 'E';
    if ChBF.Checked then DrvStr := DrvStr + 'F';
    if ChBG.Checked then DrvStr := DrvStr + 'G';
    Ini.ValueString ('Drives', DrvStr);
    Ini.Free;  
  end;

  Form1.Free;                                              // release memory
  Applet.Free;
end;


end.
