/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX or
echo run install2.cmd .
exit
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
/*-- get the command line --*/
parse arg sourcedir destdir


call SysCls
readmefile = 'readme.txt'
readmename = 'Read me'
bDeu = "2 "
fWinMan = 0


  /* Go search for the OS2.INI file, this will be our bootdrive */
  testos2path = SysSearchPath('PATH', 'OS2.INI');
  bootdrive = FILESPEC("drive", testos2path);
  os2path = FILESPEC("path",testos2path);
  ver = SysOS2Ver()

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for ELSA Video Driver'
  say '(Default: 'bootdrive'\WINOS232):'
  /*-- if error --*/
  parse pull destdir
  if destdir = ' ' then do
    destdir = bootdrive'\WINOS232'
  end
end


  DestDrive = FILESPEC("drive", destdir)
if sourcedir = '' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

SourcePath  = substr( sourcedir, 1 ,length(sourcedir) - 1 )


/*-- do main screen --*/
call SysCls
say
say '                   ELSA Video Driver Installation'
say
say 'The ELSA Video Driver will be Installed with the following settings:'
say
say 'Source directory: "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation cancelled.'
  exit
end

  SourceDrive = FILESPEC("drive", sourcedir)

     ScreenSys = SysSearchPath('PATH', 'screen01.sys');
     "@attrib -r -h -s "||ScreenSys
     if ScreenSys > ' ' then
        "@copy "||ScreenSys||" "||bootdrive||os2path||"*.ibm"
     call CopyDriverFiles sourcedir , destdir
     "@"||DestDrive
     "@CD "||destdir
     DosSys = SysSearchPath('PATH', 'doskrnl');
     DosPath = FILESPEC("PATH", DosSys);

     VsvgaSys = bootdrive||DosPath||"vsvga.*"
     call SysFileTree VsvgaSys , 'file' , 'F'
     if file.0 > 0 then do
        "@attrib -r -h -s "||bootdrive||DosPath||"vsvga.sys"
     end
     "@attrib -r -h -s "||bootdrive||os2path||"dll\*.dll"
     if DosSys > " " then
        "@copy "||destdir||"\vsvga.sys "||bootdrive||DosPath||"*.*"
     if (COMPARE(ver,'2.1') < 4) then do
        "@copy "||destdir||"\elsainst.dll "||bootdrive||os2path||"dll"
        "@copy "||bootdrive||os2path||"install\dspinstl.exe"||" "||destdir
     end

     call SaveWinIni DestDrive destdir

     DSPINSTL.EXE                       /* go execute DSPINSTL */
     say ""
/*-- create a program object --*/
call SysCls
say
say
say
say
say 'ELSA Resolution Manager can be installed as an object on your desktop.'
say 'Do you want to create it now(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call WinMan

say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "ELSA Video Configuration",,
                    "<WP_DESKTOP>",,
                    "OBJECTID=<ELSAFLDR>;ICONFILE="||destdir||"\wininst.ICO", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end


say readmefile||' file,'
x = SysCreateObject("WPProgram",,
                    readmename,,
                    "<ELSAFLDR>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\"||readmefile)

say 'and the Program file.'
x = SysCreateObject("WPProgram",,
                    "ELSA Resolution Manager",,
                    "<ELSAFLDR>",,
                    "EXENAME="||destdir||"\WININST.EXE;STARTUPDIR="||destdir)


WinMan:

  winpath = strip(SysIni('USER' , 'PM_INSTALL', 'WINOS2_LOCATION'),'T',x2c('00'))
 
  if  winpath  = "ERROR:"  then
   do
       winpath = os2path||'mdos\winos2'
     end




winlen = length(winpath)
if substr( winpath, winlen, 1 ) \= '' then do
   winlen = length(winpath) - 1
end


WinManMsg:
say
say
say
say
say 'Please insert the WINGUI diskette/CD '
say '(diskette into drive a:) '
say 'Continue ? (Y/n)'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call GoodBye

param = bDeu||winpath

call SysFileTree sourcedir||'..\win31\winman.ex_', 'file' , 'F'

if file.0 = 0 then
  do
   call SysFileTree 'a:\winman.ex_', 'file' , 'F'
   if file.0 = 0 then
    do
      BEEP(250,250)
      BEEP(250,250)
      call WinManMsg
    end
   else
      "@call wmancopy.bat "||param
  end
else
  do
    "@"||SourceDrive
    "@"||SourcePath
    "@call wcdcopy.bat "||param
    DestDrive
  end





say 'Please wait, while coping and expanding the windows driver...'
say

fWinMan = 1

call GoodBye




GoodBye:
/*-- exit with a goodbye --*/
     call RestoreWinIni fWinMan DestDrive destdir
call SysCls
say
say
say
     if fWinMan = 0 then do
        say 'ELSA Windows Resolution Manager (WINMan) was not installed.'
     end

say
say 'ELSA Video Adapter Driver (V 03.18.14) was installed successfully.'
say 'Please reboot your system.'
say
say 'ELSA Video Configuration Editor has been installed on your system.'
say
say 'Be sure to read the file README for up-to-date information.'
say
exit


INST_EXIT:
  EXIT



CopyDriverFiles: Arg SrcDrive , DestDir

  DestDrive = FILESPEC("drive",DestDir)
  /*-- create the dest. dir --*/
  "@"||DestDrive
  rc = SysMkDir(DestDir)
  if rc = 0 then do
    say 'The directory ' DestDir ' was created successfully.'
  end
  else do
    if SysFileTree(DestDir,file,D)>0 then
    do
       say 'The directory ' DestDir ' could not be created successfully; cancelling.'
       exit
    end
  end
  say 'Please wait ....'
  "@xcopy "||SrcDrive||"*.* "||DestDir
  return

SaveWinIni: arg backdr backcd
  call SysIni 'USER' , 'PM_INSTALL', 'WINOS2_LOCATION'
  winpath = result
  windrive = FILESPEC("drive", result);
  if result = "ERROR:"  then
     do
     winpath = os2path||'mdos\winos2'
     windrive = bootdrive
     end

  "@"||windrive
  "@cd "||winpath
  "@copy win.ini win.tmp"

  backdr
  "@cd "||backcd


  return


RestoreWinIni: arg fRestore backdr backcd
  call SysIni 'USER' , 'PM_INSTALL', 'WINOS2_LOCATION'
  winpath = result
  windrive = FILESPEC("drive", result);
  if result = "ERROR:"  then
     do
     winpath = os2path||'mdos\winos2'
     windrive = bootdrive
     end

  "@"||windrive
  "@cd "||winpath
  if fRestore = 0 then do
     "@copy win.tmp win.ini"
  end
  "@del win.tmp"

  "@"||backdr
  "@cd "||backcd

  return

