/*      Program Title:  SGC.H
	Author  :       Zhao GuoWei.
	Data    :       Dec. 18, 1992
	Program Function :
			Head file of general sound galaxy card C source code
	Modify Record   :
	@1 Jun. 8,  1993: Add low cost Pro 16 flag.
	@2 Sep. 9,  1993: Add Gateway 2000 Basic Audio flag.
	@3 Oct. 27, 1993: Change function prototype GetEnvSetting()
			  to sgGetEnvSetting().
	@4 Oct. 27, 1993: Add two miscellaneous function prototypes
				int SetSGIrq(int IRQ);
				int SetNXProDefaultVol(void);
*/

#define TRUE            1               /* boolen definition */
#define FALSE           0
#define ERROR           -1
#define OK              0
#define ON              1
#define OFF             0

/*
	   Card detecting and testing
*/
#define NX              2               /* sound type definition */
#define BX              3
#define BX2             5
#define NX2             6
#define NXPRO           7
#define NXPRO16         8
#define PRO16           9               /* pro 16 (low cost) @1 */
#define CLINTON         12              /* clinton or 16 CD */
#define SIA             15
#define BX3             16
#define WASHINGTON      17
#define LATEST          17

#define OEMGWBASIC      BX2             /* @2 for Gateway 2000 basic audio OEM */

#define MSBA            20
#define SB              80
#define SBPRO           81
#define SBPRO16         82

/*      Base address definition         */
#define ADDX_220        0x220           /* sound galaxy base i/o address */
#define ADDX_240        0x240
#define ADDX_530        0x530           /* sound system base i/o address */
#define ADDX_604        0x604
#define ADDX_E80        0xE80
#define ADDX_F40        0xF40
#define ERROR_ADX       -1              /* base address definition */

/*      IRQ definition         */
#define IRQ2            2
#define IRQ3            3
#define IRQ5            5
#define IRQ7            7
#define IRQ9            9
#define IRQ10           10
#define IRQ11           11
#define IRQ_NOFIND      0

/*      DMA channel definition  */
#define DMA_CHNEL_0     0
#define DMA_CHNEL_1     1
#define DMA_CHNEL_3     3

/*
 *      EEROM setting and detecting
 */
/* CD ROM information */
#define PANASONIC       1
#define MITSUMI         0
#define ENABLE          1
#define DISABLE         0
#define ADDX_300        0x300        /* sound galaxy cdrom base i/o address */
#define ADDX_320        0x320

/*
 *      Volume control chip type ( Function GetVolCtrlChip () )
 */
#define TDA             0xff            /* TDA chip */
#define TFK             0x00            /* TFK chip */

/*
 *      Sound card mode
 */
#define BA_MODE         0
#define SG_MODE         1


/*  Data definition for general SGC routines  */
extern  unsigned        sg_io_addx ;
extern  unsigned        sg_int_num ;
extern  unsigned        sg_dma_channel ;

/* Function prototype for sggen.lib */
void delay(unsigned);

/*  Function prototypes for general SGC routines  */
int      TestBaseAddr (void) ;          /* test sound card bas i/o address */
void     ResetDSP (void) ;              /* reset dsp chip */
int      TestSoundCardType (void) ;     /* test sound card type */
unsigned sgGetEnvSetting(void) ;        /* @3 get enviroument parameter */
unsigned sg_scan_int(void) ;            /* scan interrupt on sound card */
unsigned sg_test_int(void) ;            /* test sound card interrupt */
int      sg_test_dma(void) ;            /* test dma channel */

/* Sound galaxy DSP special command */
				/* other sound card compitiable DSP */
int     SetSBVer20 (void) ;             /* set to sound blaster ver 2.0 */
int     SetSBVer30 (void) ;             /* set to sound blaster ver 3.0 */
int     SetThunder (void) ;             /* set to thunder board */
unsigned GetDSPVersion (void) ;         /* get dsp version */
void    SetFilter (int ) ;              /* set dsp filter on/off */
unsigned char  GetRestoreByte (unsigned char) ;  /* get byte from EEROM */
int     SetRestoreByte (unsigned char, unsigned char) ;
						/* set byte to EEROM */
void    SetDSPSilence (int ) ;          /* set dsp silence mode */
void    GetCpyright (char * ) ;         /* get dsp copy right message */
unsigned ReadDSPAdcBT (void) ;          /* read adc base line and threshold */
void    SetThreshold (int ) ;           /* set threshold value */
unsigned char GetVolCtrlChip (void);    /* get volume control chip type.
						i.e. TDA and TFK */
unsigned char GetConfig (void) ;        /* get current configuration */
int  SetCardConfig (unsigned char ) ;
			/* set card configuration to current configuration */

void    SetEEPROMaddx (int ) ;          /* set base i/o address for EEPROM */
int     SetEEPROMirq (int ) ;           /* set irq setting for EEPROM */
int     SetEEPROMdma (int ) ;           /* set dma channel for EEPROM */
int     GetGamePortStatus (void) ;      /* get game port status from EEPROM */
void    SetEEPROMgameport (int ) ;      /* set game port address for EEPROM */
int     GetCDROMInfo (void) ;           /* get current CD ROM information */
void    SetEEPROMcdrom (int ) ;         /* set current CD ROM type */
int     GetCDROMAddr (void) ;           /* get CD ROM base address */
void    SetEEPROMcdromaddx (int );     /* set CD ROM base address for EEPROM */

/*
 *      Get or Set sound card current status
 */

unsigned char GetVolCtrlChip (void);    /* get volume control chip type.
						i.e. TDA and TFK */
unsigned char GetConfig (void) ;        /* get current configuration */
int  SetCardConfig (unsigned char ) ;
int  SetCurStatusAddx (int ) ;          /* set current address status */
int  SetCurStatusIrq (int ) ;           /* set current IRQ status */
int  SetCurStatusDMA (int ) ;           /* set current DMA status */

/*
 *      Microsoft Sound Systems testing function
 */

int  TestMSCSoundCardType (void) ;      /* test MSC sound card type */
unsigned int TestMSBABaseAddr (void) ;  /* test MSBA base address */
int  TestCodecIRQ (int , int ) ;        /* IRQ validated for Codec chip */
int  ScanCodecIRQ (void) ;              /* scan codec IRQ */
void SwitchSoundMode (int mode) ;       /* switch between SG and MSBA mode */
int  ReleaseCodecSrc (void) ;           /* disable CODEC chip */
unsigned char GetDataFmCodec (unsigned char );  /* @2 */
void SendDataToCodec (unsigned char, unsigned char );   /* @2 */

/****************
	Sound Galaxy PRO 16
*****************/

/*
 *      PRO 16 sound card mode
 */
#define SBMODE          0               // sound blaster mode
#define MSMODE          1               // microsoft mode
#define MS8BITMODE      2               // microsoft mode and sb mixer
#define MS16BITMODE     3               // 16 bit codec mode.


/********************* Function prototype *******************/
void P16SetMode (int );
int  P16Init (void);
unsigned P16_scan_int (void);
int  P16_test_dma (void);

/* @4 ********* Misc routines *********/
//int SetSGIrq(int IRQ);
//int SetNXProDefaultVol(void);

/* EOF: SGC.H */

