/* ------------------------------------------------------------------------ */
/*                                                                          */
/*   TITLE       : DEMOWDR1.C (MSC Version)                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates how to perform wave recording using      */
/*       the SGWAVE.LIB library.  The wave recording is done using the      */
/*       disk buffering method.                                             */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <conio.h>

//#include "galaxy.h"
#include "sgsdk.h"
#include "sgc.h"

/* Function prototypes */
void RecordFile(char *szFilename);
void RecordTillStopped(void);

main()
{
    unsigned version_number;
    int      iDSPPort=0x220, iIRQ=7, iDMA=1;


    /* Display SG SDK version number */
    version_number = sgGetWavLibVersion();
    printf("Sound Galaxy Developer Kit, ");
    printf("SGWAVE Library Version ");
    printf("%d.%02d\n\n", (version_number>>8) & 0xff, version_number & 0xff);

    /* set to Sound Blaster mode */
    if (!sgSetMode(SB8MODE))
	printf("Set to Sound Blaster compatible mode.\n");

    /***
       Insert BLASTER environment and CARD detection here if desired;
       otherwise, use the configuration program for Sound Galaxy cards
       to set to the desired settings

       Set global variables to the desired IO address, IRQ and DMA channel
       Remember to use the supplied configuration program to configure
       your sound card
    ***/
    printf("Please wait...acquiring card settings...\n");

    iDSPPort = TestBaseAddr();
    if (iDSPPort<0x220 || iDSPPort>0x240)
    {
	printf("Wrong base I/O address setting: %d\n", iDSPPort);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetBaseAddress(iDSPPort);

    iIRQ = sg_scan_int();
    if (iIRQ<=0)
    {
	printf("Wrong IRQ setting: %d\n", iIRQ);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetIRQ(iIRQ);

    iDMA = sg_test_dma();
    if (iDMA<0)
    {
	iDMA = 1;
    }
    sgSetDMA(iDMA);

    printf("DSP Port Address = 0x%x\n", iDSPPort);
    printf("IRQ              = %d\n", iIRQ);
    printf("DMA Channel      = %d\n", iDMA);

    sgDSPAux_set_input_source(MICROPHONE);
    sgDSPAux_SetVolume(MICVOL,7,7);

    if (!sgDSPwd_init())
	{
	RecordFile("DEMO.WAV");

	sgDSPwd_terminate();
    }
	else
	printf ("Error on library initialization.\n");

    return(0);
}


/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   RecordFile (char *szFilename)                                          */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Record wave with the filename specified.                           */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFilename :- filename to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

void RecordFile(char *szFilename)
{
    int     Handle;


    /* create and record a wave file */
    if ( !(_dos_creat(szFilename, _A_NORMAL, &Handle)) )
    {
	sgDSPwd_speaker(0);

	printf("Press any key to start recording...\n");
	getch();

	sgDSPAux_set_stereo(STEREO);
	if ( sgDSPwd_input(Handle, 11025, 2) == NO_ERROR )
	{
	    RecordTillStopped();

	    //if ( ctvd_drv_error() )
	    //    ShowError();
	    //else
		printf("Wave recording ended.\n");
	}
	//else
	//    ShowError();

	_dos_close(Handle);
    }
    else
	printf ("Create %s file error.\n", szFilename );
}


/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   RecordTillStopped (void)                                               */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Starts wave recording. Press ESC key to terminate the recording.   */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma loop_opt(off)   /* turn off loop optimiaztion */
void RecordTillStopped(void)
{
    unsigned    wKey;

    printf("Press <ESC> key to stop recording...\n");

    /* Polls for hot key while recording wave file */
    while ( sg_voice_status )
    {
	if ( _bios_keybrd( _KEYBRD_READY ) )
	{
	    /* check for ESC key */
	    if ( (wKey = _bios_keybrd(_KEYBRD_READ) & 0xff) == 0x1b )
		sgDSPwd_stop();
	}
    }

    printf ("Wave recording stopped.\n");
}
#pragma loop_opt()


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   ShowError (void)                                                       */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Display error occurred during the process of wave I/O.             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

void ShowError (void)
{
    //int     Err ;


    /* Show the driver error and the DOS extended error code */
    //Err = ctvd_drv_error() ;

    //printf("Driver error = %2d\n", Err) ;

    //Err = ctvd_ext_error();
    //if ( Err != 0 )
    //    printf ("DOS error = %2d\n", Err) ;
}
