/* ------------------------------------------------------------------------ */
/*                                                                          */
/*   TITLE       : DEMOMIX.C (MSC Version)                                  */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates the use of the various mixer functions   */
/*       in the SGMIXER.LIB (NXPRO16 or earlier) or SGMIXERX.LIB (PRO16)    */
/*       library.                                                           */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <io.h>
#include  <dos.h>
#include  <bios.h>
#include  <stdio.h>
#include  <conio.h>
#include  <fcntl.h>
#include  <string.h>
#include  <stdlib.h>

//#include  "galaxy.h"
#include  "sgsdk.h"
#include  "sgc.h"

void mixertest(void)
{
    sgDSPAux_set_stereo(STEREO);

    sgDSPAux_set_input_source(CD);

    sgDSPAux_set_input_freq(LOWFILTER);

    printf("Previous filter status = %d\n", sgDSPAux_ANFI_control(FILTER_ON));
    printf("Previous filter status = %d\n", sgDSPAux_DNFI_control(FILTER_OFF));
    printf("Current filter status = %d\n", sgDSPAux_get_ANFI());
    printf("Current filter status = %d\n", sgDSPAux_get_DNFI());

    sgDSPAux_Mix(ON);
    sgDSPAux_Step(STEP16);
#ifndef WASHINGTON16    
    sgDSPAux_AGC(ON);
    sgDSPAux_UnMute(ON);

    printf("Previous Bass volume = %d\n", sgDSPAux_ToneControl(BASSVOL, 1, 4));
    printf("Previous Treble volume = %d\n", sgDSPAux_ToneControl(TREBLEVOL, 2, 7));

    printf("Previous Record gain = %d\n", sgDSPAux_SetGain(RECGAIN, 0, 1));
    printf("Previous Playback gain = %d\n", sgDSPAux_SetGain(PLAYGAIN, 2, 3));
#endif
    /* for SG NXPRO16 or earlier  */
#ifndef PRO16CARD
    printf("Previous Master volume = %d\n", sgDSPAux_SetVolume(MASTERVOL, 10, 14));
    printf("Previous Voice volume = %d\n", sgDSPAux_SetVolume(VOICEVOL, 10, 14));
    printf("Previous FM volume = %d\n", sgDSPAux_SetVolume(FMVOL, 10, 14));
    printf("Previous CD volume = %d\n", sgDSPAux_SetVolume(CDVOL, 10, 14));
    printf("Previous Line-in volume = %d\n", sgDSPAux_SetVolume(LINE_INVOL, 10, 14));
    printf("Previous Microphone volume = %d\n", sgDSPAux_SetVolume(MICVOL, 10, 14));
#endif

    /* for SG PRO16 only */
#ifdef PRO16CARD
    printf("Previous Master volume = %d\n", sgDSPAux_SetVolume(MASTERVOL, 50, 24));
    printf("Previous Voice volume = %d\n", sgDSPAux_SetVolume(VOICEVOL, 20, 24));
    printf("Previous FM volume = %d\n", sgDSPAux_SetVolume(FMVOL, 20, 24));
    printf("Previous CD volume = %d\n", sgDSPAux_SetVolume(CDVOL, 10, 14));
    printf("Previous Line-in volume = %d\n", sgDSPAux_SetVolume(LINE_INVOL, 10, 14));
    printf("Previous Microphone volume = %d\n", sgDSPAux_SetVolume(MICVOL, 10, 14));
    printf("Previous Wave Synth volume = %d\n", sgDSPAux_SetVolume(WAVESYNVOL, 20, 4));
    printf("Previous PC Speaker volume = %d\n", sgDSPAux_SetVolume(SPEAKERVOL, 21, 11));
#endif

}


main()
{
    unsigned version_number;
    int iDSPPort=0x220, iIRQ=7, iDMA=1;

    /* Display SG SDK version number */
    version_number = sgGetMixLibVersion();
    printf("Sound Galaxy Developer Kit, ");
#ifndef PRO16CARD
    printf("SGMIXER Library Version ");
#endif
#ifdef PRO16CARD
    printf("SGMIXERX Library Version ");
#endif
    printf("%d.%02d\n\n", (version_number>>8) & 0xff, version_number & 0xff);

    /* set to Sound Blaster mode */
    if (!sgSetMode(SB8MODE))
        printf("Set to Sound Blaster compatible mode.\n");

    /***
       Insert BLASTER environment and CARD detection here if desired;
       otherwise, use the configuration program for Sound Galaxy cards
       to set to the desired settings

       Set global variables to the desired IO address, IRQ and DMA channel
       Remember to use the supplied configuration program to configure
       your sound card
    ***/
    printf("Please wait...acquiring card settings...\n");

    iDSPPort = TestBaseAddr();
    if (iDSPPort<0x220 || iDSPPort>0x240)
    {
        printf("Wrong base I/O address setting: %d\n", iDSPPort);
        printf("Please use configuration utility.\n");
        exit(1);
    }
    sgSetBaseAddress(iDSPPort);

    iIRQ = sg_scan_int();
    if (iIRQ<=0)
    {
        printf("Wrong IRQ setting: %d\n", iIRQ);
        printf("Please use configuration utility.\n");
        exit(1);
    }
    sgSetIRQ(iIRQ);

    iDMA = sg_test_dma();
    if (iDMA<0)
    {
        iDMA = 1;
    }
    sgSetDMA(iDMA);

    printf("DSP Port Address = 0x%x\n", iDSPPort);
    printf("IRQ              = %d\n", iIRQ);
    printf("DMA Channel      = %d\n", iDMA);

    /* test mixer functions */
    mixertest();

    return(0);
}

/* EOF: DEMOMIX.C */

